/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.grpc.client;

import cn.iosd.starter.grpc.client.InitializeGrpcClientBeans;
import cn.iosd.starter.grpc.client.annotation.GrpcClient;
import cn.iosd.starter.grpc.client.properties.GrpcChannelProperties;
import cn.iosd.starter.grpc.client.properties.GrpcClientProperties;
import cn.iosd.starter.grpc.client.vo.GrpcChannel;
import cn.iosd.starter.grpc.client.vo.GrpcClientBeans;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;

@Configuration
public class GrpcClientService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientService.class);
    @Autowired
    private GrpcClientProperties grpcClientProperties;
    @Autowired
    private InitializeGrpcClientBeans beanInjection;

    public void afterPropertiesSet() throws Exception {
        if (this.beanInjection != null && this.beanInjection.getGrpcClientBeans() != null && this.beanInjection.getGrpcClientBeans().getInjections() != null) {
            GrpcClientBeans grpcClientBeans = this.beanInjection.getGrpcClientBeans();
            List<GrpcClientBeans.GrpcClientBean> lsGrpcClientBean = grpcClientBeans.getInjections();
            lsGrpcClientBean.forEach(v -> {
                GrpcClient annotation = v.client();
                Class<?> type = v.field().getType();
                Field field = v.field();
                Object bean = v.bean();
                if (this.grpcClientProperties.getChannel() != null && this.grpcClientProperties.getChannel().get(annotation.value()) != null) {
                    GrpcChannelProperties properties = this.grpcClientProperties.getChannel().get(annotation.value());
                    GrpcChannel client = new GrpcChannel(properties.getAddress());
                    Object object = client.getBlockingStub(type);
                    boolean accessible = field.canAccess(bean);
                    ReflectionUtils.makeAccessible((Field)field);
                    try {
                        field.set(bean, object);
                    }
                    catch (IllegalAccessException e) {
                        log.error("\u5bf9\u8c61Bean\u6ce8\u5165\u914d\u7f6eGrpcChannel\u5f02\u5e38\uff1a", (Object)e.getMessage());
                        throw new RuntimeException(e);
                    }
                    field.setAccessible(accessible);
                } else {
                    log.error("\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931\u8bf7\u6838\u67e5\uff0cGrpcChannel\u672a\u88c5\u914d\u503c\uff1a{}", (Object)annotation.value());
                }
            });
            log.info("\u5b8c\u6210GrpcChannel\u88c5\u914d");
        }
    }
}

