/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.grpc.server;

import cn.iosd.starter.grpc.server.annotation.GrpcService;
import cn.iosd.starter.grpc.server.properties.GrpcServerProperties;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class GrpcServerService
implements InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(GrpcServerService.class);
    @Autowired
    private GrpcServerProperties grpcServerProperties;
    private Server server;
    private static ApplicationContext context = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public void afterPropertiesSet() throws IOException {
        GrpcServerService server = new GrpcServerService();
        server.start(this.grpcServerProperties.getPort());
        log.info("GrpcServer start port:{}", (Object)this.grpcServerProperties.getPort());
    }

    private void start(int port) throws IOException {
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)port);
        if (context != null) {
            Map beansWithAnnotationMap = context.getBeansWithAnnotation(GrpcService.class);
            beansWithAnnotationMap.forEach((key, value) -> serverBuilder.addService((BindableService)value));
        }
        this.server = serverBuilder.build();
        this.server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.server.shutdown();
            log.info("GrpcServer shut down");
        }));
    }
}

