/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.grpc.client.vo;

import cn.iosd.starter.grpc.client.interceptor.ClientCallStartHeaders;
import cn.iosd.starter.grpc.client.interceptor.CustomClientInterceptor;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class GrpcChannel {
    private static final ConcurrentHashMap<String, ManagedChannel> CHANNELS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Object> STUBS = new ConcurrentHashMap();

    public static ManagedChannel getChannel(String target, long timeout, ClientCallStartHeaders headers) {
        String key = target + timeout + headers;
        CHANNELS.computeIfAbsent(key, k -> ManagedChannelBuilder.forTarget((String)target).usePlaintext().intercept(new ClientInterceptor[]{new CustomClientInterceptor(timeout, TimeUnit.MILLISECONDS, headers)}).build());
        return CHANNELS.get(key);
    }

    public static <T> T getBlockingStub(ManagedChannel channel, Class<T> type) {
        if (channel == null) {
            throw new IllegalArgumentException("No channel");
        }
        String key = channel + type.getName();
        Object stub = STUBS.computeIfAbsent(key, k -> {
            try {
                Constructor constructor = type.getDeclaredConstructor(Channel.class, CallOptions.class);
                constructor.setAccessible(true);
                return constructor.newInstance(channel, CallOptions.DEFAULT);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("\u65e0\u6cd5\u521b\u5efa\u6307\u5b9a\u7c7b\u578b\u7684Stub", e);
            }
        });
        return type.cast(stub);
    }
}

