/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.encrypt.rsa.utils;

import cn.iosd.starter.encrypt.rsa.annotation.DecryptRequestParams;
import cn.iosd.starter.encrypt.rsa.annotation.EncryptResponseParams;
import cn.iosd.starter.encrypt.rsa.annotation.UnEncrypted;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class CheckAnnotationUtils {
    private static final Set<Class<? extends Annotation>> MAPPING_ANNOTATIONS = new HashSet<Class>(Arrays.asList(RequestMapping.class, GetMapping.class, PostMapping.class, PutMapping.class, DeleteMapping.class));

    public static <A extends Annotation> boolean check(boolean isGlobalCryptoEnabled, MethodParameter parameter, Class<A> annotationType) {
        if (CheckAnnotationUtils.hasAnnotation(parameter, UnEncrypted.class)) {
            return false;
        }
        if (CheckAnnotationUtils.hasAnnotation(parameter, DecryptRequestParams.class) || CheckAnnotationUtils.hasAnnotation(parameter, EncryptResponseParams.class)) {
            return CheckAnnotationUtils.hasAnnotation(parameter, annotationType);
        }
        return isGlobalCryptoEnabled ? CheckAnnotationUtils.hasMappingAnnotation(parameter.getMethodAnnotations()) || CheckAnnotationUtils.hasAnnotation(parameter, annotationType) : CheckAnnotationUtils.hasAnnotation(parameter, annotationType);
    }

    private static boolean hasAnnotation(MethodParameter parameter, Class<? extends Annotation> annotationType) {
        return parameter.hasMethodAnnotation(annotationType);
    }

    private static boolean hasMappingAnnotation(Annotation[] annotations) {
        return Arrays.stream(annotations).anyMatch(CheckAnnotationUtils::isMappingAnnotation);
    }

    private static boolean isMappingAnnotation(Annotation annotation) {
        return MAPPING_ANNOTATIONS.contains(annotation.annotationType());
    }
}

