/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.encrypt.rsa.annotation;

import cn.iosd.starter.encrypt.rsa.annotation.DecryptRequestParams;
import cn.iosd.starter.encrypt.rsa.properties.RsaProperties;
import cn.iosd.starter.encrypt.rsa.utils.RsaUtils;
import cn.iosd.utils.jackson.JsonMapperThreadLocal;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DecryptRequestParamsResolve
implements HandlerMethodArgumentResolver {
    @Autowired
    private RsaProperties rsaProperties;
    @Value(value="${simple.encrypt.rsa.secureParams.urlField:encryptedData}")
    private String urlField;

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getMethodAnnotation(DecryptRequestParams.class) != null;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String privateKey = this.rsaProperties.getPrivateKey();
        Assert.notNull((Object)privateKey, (String)"privateKey must not be null");
        Map parameterMap = webRequest.getParameterMap();
        Assert.notNull(parameterMap.get(this.urlField), (String)("Request field of URL query parameters cannot be empty\uff1a" + this.urlField));
        String encryptedContent = ((String[])parameterMap.get(this.urlField))[0];
        String contentsDecrypt = RsaUtils.decrypt(encryptedContent, privateKey);
        RsaUtils.timestampValidation(this.rsaProperties.getTimestampValidation(), contentsDecrypt);
        return JsonMapperThreadLocal.getObjectMapper().readValue(contentsDecrypt, parameter.getParameterType());
    }
}

