/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.encrypt.desensitized.utils;

import cn.iosd.starter.encrypt.desensitized.vo.SensitiveRule;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class DesensitizedUtils {
    private static final String MASK_STR = "*";
    public static final Map<SensitiveRule, Function<String, String>> DESENSITIZE_MAP = new EnumMap<SensitiveRule, Function<String, String>>(SensitiveRule.class);

    public static String desValue(String origin, int prefixLen, int suffixLen) {
        if (origin == null || origin.isEmpty()) {
            return origin;
        }
        StringBuilder sb = new StringBuilder();
        int len = origin.length();
        for (int i = 0; i < len; ++i) {
            if (i < prefixLen || i >= len - suffixLen) {
                sb.append(origin.charAt(i));
                continue;
            }
            sb.append(MASK_STR);
        }
        return sb.toString();
    }

    public static String maskValue(String origin, int prefixLen, int suffixLen) {
        if (origin == null || origin.isEmpty() || prefixLen + suffixLen >= origin.length()) {
            return origin;
        }
        int len = origin.length();
        int end = len - suffixLen;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i < prefixLen || i >= end) {
                sb.append(MASK_STR);
                continue;
            }
            sb.append(origin.charAt(i));
        }
        return sb.toString();
    }

    public static String chineseName(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return fullName;
        }
        int len = fullName.length();
        int prefixLen = len <= 2 ? 0 : (len == 3 ? 1 : 2);
        int suffixLen = 1;
        return DesensitizedUtils.desValue(fullName, prefixLen, suffixLen);
    }

    public static String idCardNum(String id) {
        return DesensitizedUtils.desValue(id, 6, 4);
    }

    public static String fixedPhone(String num) {
        return DesensitizedUtils.desValue(num, 0, 4);
    }

    public static String mobilePhone(String num) {
        return DesensitizedUtils.desValue(num, 3, 4);
    }

    public static String address(String address) {
        return DesensitizedUtils.desValue(address, 6, 0);
    }

    public static String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return email;
        }
        int index = StringUtils.indexOf((CharSequence)email, (int)64);
        if (index <= 1) {
            return email;
        }
        String preEmail = DesensitizedUtils.desValue(email.substring(0, index), 1, 0);
        return preEmail + email.substring(index);
    }

    public static String bankCard(String cardNum) {
        return DesensitizedUtils.desValue(cardNum, 6, 4);
    }

    public static String password(String password) {
        return "******";
    }

    static {
        DESENSITIZE_MAP.put(SensitiveRule.CHINESE_NAME, DesensitizedUtils::chineseName);
        DESENSITIZE_MAP.put(SensitiveRule.ID_CARD, DesensitizedUtils::idCardNum);
        DESENSITIZE_MAP.put(SensitiveRule.FIXED_PHONE, DesensitizedUtils::fixedPhone);
        DESENSITIZE_MAP.put(SensitiveRule.MOBILE_PHONE, DesensitizedUtils::mobilePhone);
        DESENSITIZE_MAP.put(SensitiveRule.ADDRESS, DesensitizedUtils::address);
        DESENSITIZE_MAP.put(SensitiveRule.EMAIL, DesensitizedUtils::email);
        DESENSITIZE_MAP.put(SensitiveRule.BANK_CARD, DesensitizedUtils::bankCard);
        DESENSITIZE_MAP.put(SensitiveRule.PASSWORD, DesensitizedUtils::password);
    }
}

