/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.encrypt.desensitized.annotation;

import cn.iosd.starter.encrypt.desensitized.annotation.SensitiveEntity;
import cn.iosd.starter.encrypt.desensitized.annotation.SensitiveField;
import cn.iosd.starter.encrypt.desensitized.utils.DesensitizedUtils;
import cn.iosd.starter.encrypt.desensitized.vo.SensitiveRule;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Aspect
@Component
@ConditionalOnProperty(name={"simple.encrypt.desensitized.enabled"}, havingValue="true", matchIfMissing=true)
public class DesensitizedHandler {
    @Around(value="@annotation(cn.iosd.starter.encrypt.desensitized.annotation.Desensitized)")
    public Object idempotent(ProceedingJoinPoint point) throws Throwable {
        Object responseObj = point.proceed();
        this.desensitizeAndEncryptObjects(responseObj);
        return responseObj;
    }

    private void desensitizeAndEncryptObjects(Object responseObj) throws IllegalAccessException {
        Field[] fields;
        if (responseObj instanceof List) {
            for (Object singleObj : (List)responseObj) {
                this.desensitizeAndEncryptObjects(singleObj);
            }
        }
        for (Field field : fields = responseObj.getClass().getDeclaredFields()) {
            Object fieldValue;
            SensitiveField sensitiveField = field.getAnnotation(SensitiveField.class);
            if (sensitiveField != null) {
                ReflectionUtils.makeAccessible((Field)field);
                fieldValue = field.get(responseObj);
                String deValue = this.desensitize(String.valueOf(fieldValue), sensitiveField.rule(), sensitiveField.prefixLen(), sensitiveField.suffixLen());
                field.set(responseObj, deValue);
                continue;
            }
            if (!field.isAnnotationPresent(SensitiveEntity.class)) continue;
            ReflectionUtils.makeAccessible((Field)field);
            fieldValue = field.get(responseObj);
            this.desensitizeAndEncryptObjects(fieldValue);
        }
    }

    private String desensitize(String value, SensitiveRule sensitiveRule, int prefixLen, int suffixLen) {
        return switch (sensitiveRule) {
            case SensitiveRule.CUSTOM_BROADSIDE_CLEAR_TEXT -> DesensitizedUtils.desValue(value, prefixLen, suffixLen);
            case SensitiveRule.CUSTOM_BROADSIDE_MASK_TEXT -> DesensitizedUtils.maskValue(value, prefixLen, suffixLen);
            default -> (String)DesensitizedUtils.DESENSITIZE_MAP.getOrDefault((Object)sensitiveRule, Function.identity()).apply(value);
        };
    }
}

