/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.encrypt.rsa.utils;

import cn.iosd.starter.encrypt.rsa.properties.RsaProperties;
import cn.iosd.utils.JsonMapperThreadLocal;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RsaUtils {
    private static final String RSA = "RSA";
    private static final int KEY_SIZE = 2048;

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA);
        SecureRandom random = new SecureRandom();
        keyPairGenerator.initialize(2048, random);
        return keyPairGenerator.generateKeyPair();
    }

    public static String encrypt(String data, String publicKey) throws Exception {
        PublicKey key = RsaUtils.getPublicKey(publicKey);
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, key);
        byte[] dataBytes = data.getBytes();
        int blockSize = 245;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (int i = 0; i < dataBytes.length; i += blockSize) {
            int length = Math.min(blockSize, dataBytes.length - i);
            byte[] blockBytes = new byte[length];
            System.arraycopy(dataBytes, i, blockBytes, 0, length);
            byte[] encryptedBytes = cipher.doFinal(blockBytes);
            outputStream.write(encryptedBytes);
        }
        byte[] encryptedBytes = outputStream.toByteArray();
        return Base64.encodeBase64String((byte[])encryptedBytes);
    }

    public static String decrypt(String data, String privateKey) throws Exception {
        PrivateKey key = RsaUtils.getPrivateKey(privateKey);
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, key);
        byte[] dataBytes = Base64.decodeBase64((String)data);
        int inputLength = dataBytes.length;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int offset = 0;
        int i = 0;
        while (inputLength - offset > 0) {
            byte[] cache = inputLength - offset > 256 ? cipher.doFinal(dataBytes, offset, 256) : cipher.doFinal(dataBytes, offset, inputLength - offset);
            outputStream.write(cache, 0, cache.length);
            offset = ++i * 2048 / 8;
        }
        byte[] decryptedBytes = outputStream.toByteArray();
        outputStream.close();
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

    private static PublicKey getPublicKey(String publicKeyStr) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] publicKeyBytes = Base64.decodeBase64((String)publicKeyStr);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        return KeyFactory.getInstance(RSA).generatePublic(keySpec);
    }

    private static PrivateKey getPrivateKey(String privateKeyStr) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] privateKeyBytes = Base64.decodeBase64((String)privateKeyStr);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        return KeyFactory.getInstance(RSA).generatePrivate(keySpec);
    }

    public static void timestampValidation(RsaProperties.TimestampValidation timestampValidation, String contentsDecrypt) throws JsonProcessingException {
        if (timestampValidation.getEnabled().booleanValue()) {
            JsonNode contentsDecryptedJsonNode = JsonMapperThreadLocal.getObjectMapper().readTree(contentsDecrypt);
            JsonNode timestampJsonNode = contentsDecryptedJsonNode.get("timestamp");
            if (timestampJsonNode == null) {
                throw new IllegalArgumentException("The request timestamp is missing");
            }
            long timestamp = timestampJsonNode.asLong();
            long requestExpirationTime = timestamp + timestampValidation.getExpiryMillis();
            if (System.currentTimeMillis() > requestExpirationTime) {
                throw new IllegalArgumentException("The request timestamp has expired");
            }
        }
    }
}

