/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.encode.rsa.annotation;

import cn.iosd.starter.encode.rsa.annotation.EncryptResponseParams;
import cn.iosd.starter.encode.rsa.properties.RsaProperties;
import cn.iosd.starter.encode.rsa.utils.RsaUtils;
import cn.iosd.utils.JsonMapperThreadLocal;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
@ConditionalOnProperty(name={"simple.encode.rsa.secureParams.enabled"}, havingValue="true", matchIfMissing=true)
public class EncryptResponseParamsAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(EncryptResponseParamsAdvice.class);
    @Autowired
    private RsaProperties rsaProperties;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.hasMethodAnnotation(EncryptResponseParams.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        return this.encrypt(body);
    }

    private Object encrypt(Object responseObj) {
        return Optional.ofNullable(this.rsaProperties.getPublicKey()).filter(StringUtils::isNotBlank).map(pubKey -> {
            try {
                String content = JsonMapperThreadLocal.getObjectMapper().writeValueAsString(responseObj);
                return RsaUtils.encrypt(content, pubKey);
            }
            catch (JsonProcessingException e) {
                log.error("Failed to convert object to JSON string: {}", (Object)e.getMessage());
            }
            catch (Exception e) {
                log.error("EncryptResponseParamsAdvice error: {}", (Object)e.getMessage());
            }
            return responseObj;
        }).orElseGet(() -> {
            throw new IllegalArgumentException("publicKey must not be null");
        });
    }
}

