/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.encode.rsa.annotation;

import cn.iosd.starter.encode.rsa.annotation.DecryptRequestParams;
import cn.iosd.starter.encode.rsa.properties.RsaProperties;
import cn.iosd.starter.encode.rsa.utils.RsaUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice
@ConditionalOnProperty(name={"simple.encode.rsa.secureParams.enabled"}, havingValue="true", matchIfMissing=true)
public class DecryptRequestParamsAdvice
implements RequestBodyAdvice {
    @Autowired
    private RsaProperties rsaProperties;

    public boolean supports(MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return parameter.getMethodAnnotation(DecryptRequestParams.class) != null;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        String privateKey = this.rsaProperties.getPrivateKey();
        Assert.notNull((Object)privateKey, (String)"privateKey must not be null");
        String content = new BufferedReader(new InputStreamReader(inputMessage.getBody())).lines().collect(Collectors.joining(System.lineSeparator()));
        String contentsDecrypt = "";
        try {
            contentsDecrypt = RsaUtils.decrypt(content, privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        RsaUtils.timestampValidation(this.rsaProperties.getTimestampValidation(), contentsDecrypt);
        return new DecryptRequestParamsInputMessage(inputMessage, contentsDecrypt);
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    private static class DecryptRequestParamsInputMessage
    implements HttpInputMessage {
        private final HttpHeaders headers;
        private final InputStream body;

        public DecryptRequestParamsInputMessage(HttpInputMessage inputMessage, String contentsDecrypt) {
            this.headers = inputMessage.getHeaders();
            this.body = new ByteArrayInputStream(contentsDecrypt.getBytes());
        }

        public InputStream getBody() throws IOException {
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }
}

