/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.encode.desensitized.utils;

import org.apache.commons.lang3.StringUtils;

public class DesensitizedUtils {
    private static final String MASK_STR = "*";

    public static String desValue(String origin, int prefixLen, int suffixLen) {
        if (origin == null || origin.isEmpty()) {
            return origin;
        }
        StringBuilder sb = new StringBuilder();
        int len = origin.length();
        for (int i = 0; i < len; ++i) {
            if (i < prefixLen || i >= len - suffixLen) {
                sb.append(origin.charAt(i));
                continue;
            }
            sb.append(MASK_STR);
        }
        return sb.toString();
    }

    public static String maskValue(String origin, int prefixLen, int suffixLen) {
        if (origin == null || origin.isEmpty() || prefixLen + suffixLen >= origin.length()) {
            return origin;
        }
        int len = origin.length();
        int end = len - suffixLen;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i < prefixLen || i >= end) {
                sb.append(MASK_STR);
                continue;
            }
            sb.append(origin.charAt(i));
        }
        return sb.toString();
    }

    public static String chineseName(String fullName) {
        return DesensitizedUtils.desValue(fullName, 0, 1);
    }

    public static String idCardNum(String id) {
        return DesensitizedUtils.desValue(id, 6, 4);
    }

    public static String fixedPhone(String num) {
        return DesensitizedUtils.desValue(num, 0, 4);
    }

    public static String mobilePhone(String num) {
        return DesensitizedUtils.desValue(num, 3, 4);
    }

    public static String address(String address) {
        return DesensitizedUtils.desValue(address, 6, 0);
    }

    public static String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return email;
        }
        int index = StringUtils.indexOf((CharSequence)email, (int)64);
        if (index <= 1) {
            return email;
        }
        String preEmail = DesensitizedUtils.desValue(email.substring(0, index), 1, 0);
        return preEmail + email.substring(index);
    }

    public static String bankCard(String cardNum) {
        return DesensitizedUtils.desValue(cardNum, 6, 4);
    }

    public static String password(String password) {
        return "******";
    }

    public static String key(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return key;
        }
        int viewLength = 6;
        StringBuilder tmpKey = new StringBuilder(DesensitizedUtils.desValue(key, 0, 3));
        if (tmpKey.length() > viewLength) {
            return tmpKey.substring(tmpKey.length() - viewLength);
        }
        if (tmpKey.length() < viewLength) {
            int buffLength = viewLength - tmpKey.length();
            for (int i = 0; i < buffLength; ++i) {
                tmpKey.insert(0, MASK_STR);
            }
            return tmpKey.toString();
        }
        return tmpKey.toString();
    }
}

