/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.encode.desensitized.annotation;

import cn.iosd.starter.encode.desensitized.annotation.SensitiveEntity;
import cn.iosd.starter.encode.desensitized.annotation.SensitiveField;
import cn.iosd.starter.encode.desensitized.utils.DesensitizedUtils;
import cn.iosd.starter.encode.desensitized.vo.SensitiveRule;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(name={"simple.encode.desensitized.enabled"}, havingValue="true", matchIfMissing=true)
public class DesensitizedHandler {
    @Around(value="@annotation(cn.iosd.starter.encode.desensitized.annotation.Desensitized)")
    public Object idempotent(ProceedingJoinPoint point) throws Throwable {
        Object responseObj = point.proceed();
        this.desensitizeAndEncryptObjects(responseObj);
        return responseObj;
    }

    private void desensitizeAndEncryptObjects(Object responseObj) throws Throwable {
        Field[] fields;
        if (responseObj instanceof ArrayList) {
            for (Object singleObj : (List)responseObj) {
                this.desensitizeAndEncryptObjects(singleObj);
            }
        }
        for (Field field : fields = responseObj.getClass().getDeclaredFields()) {
            Object obj;
            if (field.isAnnotationPresent(SensitiveField.class)) {
                if (!field.canAccess(responseObj)) {
                    field.setAccessible(true);
                }
                obj = field.get(responseObj);
                SensitiveField sensitiveField = field.getAnnotation(SensitiveField.class);
                String deValue = this.desensitize(String.valueOf(obj), sensitiveField.rule(), sensitiveField.prefixLen(), sensitiveField.suffixLen());
                field.set(responseObj, deValue);
                continue;
            }
            if (!field.isAnnotationPresent(SensitiveEntity.class)) continue;
            if (!field.canAccess(responseObj)) {
                field.setAccessible(true);
            }
            obj = field.get(responseObj);
            this.desensitizeAndEncryptObjects(obj);
        }
    }

    private String desensitize(String value, SensitiveRule sensitiveRule, int prefixLen, int suffixLen) {
        return switch (sensitiveRule) {
            case SensitiveRule.CHINESE_NAME -> DesensitizedUtils.chineseName(value);
            case SensitiveRule.ID_CARD -> DesensitizedUtils.idCardNum(value);
            case SensitiveRule.FIXED_PHONE -> DesensitizedUtils.fixedPhone(value);
            case SensitiveRule.MOBILE_PHONE -> DesensitizedUtils.mobilePhone(value);
            case SensitiveRule.ADDRESS -> DesensitizedUtils.address(value);
            case SensitiveRule.EMAIL -> DesensitizedUtils.email(value);
            case SensitiveRule.BANK_CARD -> DesensitizedUtils.bankCard(value);
            case SensitiveRule.PASSWORD -> DesensitizedUtils.password(value);
            case SensitiveRule.CUSTOM_BROADSIDE_CLEAR_TEXT -> DesensitizedUtils.desValue(value, prefixLen, suffixLen);
            case SensitiveRule.CUSTOM_BROADSIDE_MASK_TEXT -> DesensitizedUtils.maskValue(value, prefixLen, suffixLen);
            default -> value;
        };
    }
}

