/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.dict.annotation;

import cn.iosd.starter.dict.annotation.DictEntity;
import cn.iosd.starter.dict.annotation.DictField;
import cn.iosd.starter.dict.service.DictService;
import cn.iosd.starter.dict.vo.DictItem;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

@Aspect
@Component
public class DictAspect {
    private static final Logger log = LoggerFactory.getLogger(DictAspect.class);
    @Autowired
    private List<DictService> dictServiceList;

    public DictService getDictServiceByClass(Class<? extends DictService> dictClass) {
        return this.dictServiceList.stream().filter(dictClass::isInstance).findFirst().orElse(this.dictServiceList.get(0));
    }

    @Around(value="@annotation(cn.iosd.starter.dict.annotation.Dict)")
    public Object translateDict(ProceedingJoinPoint joinPoint) throws Throwable {
        Object responseObj = joinPoint.proceed();
        this.translateDictObjects(responseObj, new HashMap<String, List<DictItem>>(16));
        return responseObj;
    }

    private void translateDictObjects(Object responseObj, Map<String, List<DictItem>> cache) throws IllegalAccessException {
        Field[] fields;
        if (responseObj instanceof List) {
            for (Object singleObj : (List)responseObj) {
                this.translateDictObjects(singleObj, cache);
            }
        }
        for (Field field : fields = responseObj.getClass().getDeclaredFields()) {
            DictField dictFieldAnnotation = field.getAnnotation(DictField.class);
            if (dictFieldAnnotation != null) {
                this.processDictField(responseObj, field, cache, dictFieldAnnotation);
                continue;
            }
            if (!field.isAnnotationPresent(DictEntity.class)) continue;
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = field.get(responseObj);
            this.translateDictObjects(fieldValue, cache);
        }
    }

    private void processDictField(Object responseObj, Field field, Map<String, List<DictItem>> cache, DictField fieldAnnotation) throws IllegalAccessException {
        ReflectionUtils.makeAccessible((Field)field);
        Object fieldValue = field.get(responseObj);
        if (ObjectUtils.isEmpty((Object)fieldValue)) {
            log.debug("\u76ee\u6807\u5b57\u6bb5\u503c\u4e3a\u7a7a\u8df3\u8fc7\u67e5\u8be2\uff0c\u5b57\u6bb5\uff1a{}\uff0c\u5bf9\u8c61\uff1a{}", (Object)field.getName(), (Object)responseObj.toString());
            return;
        }
        String relatedField = fieldAnnotation.relatedField();
        Field related = ReflectionUtils.findField(responseObj.getClass(), (String)relatedField);
        if (related == null) {
            log.debug("\u9700\u8981\u8bbe\u7f6e\u7ffb\u8bd1\u5b57\u6bb5\u503c\u4e0d\u5b58\u5728\uff1a{}\uff0c\u5c06\u8df3\u8fc7\u67e5\u8be2\uff0c\u5bf9\u8c61\uff1a{}", (Object)relatedField, (Object)responseObj.getClass().getName());
            return;
        }
        DictService dictService = this.getDictServiceByClass(fieldAnnotation.dictImplClass());
        List dictItemList = cache.computeIfAbsent(fieldAnnotation.dictionaryParams(), dictService::getDictItemList);
        if (dictItemList == null || dictItemList.isEmpty()) {
            log.debug("\u5b57\u6bb5\uff1a{} \u83b7\u53d6\u5b57\u5178\u9879\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5 \u5b57\u5178\u53c2\u6570\uff1a{} \u670d\u52a1\u7c7b\uff1a{} \u670d\u52a1\u7c7b\u5305\u5730\u5740\uff1a{}", new Object[]{fieldAnnotation.relatedField(), fieldAnnotation.dictionaryParams(), dictService.getClass().getSimpleName(), dictService.getClass().getPackageName()});
            return;
        }
        Optional<DictItem> matchingDictItem = dictItemList.stream().filter(dictItem -> String.valueOf(fieldValue).equals(dictItem.getValue())).findFirst();
        matchingDictItem.ifPresent(dictItem -> {
            ReflectionUtils.makeAccessible((Field)related);
            ReflectionUtils.setField((Field)related, (Object)responseObj, (Object)dictItem.getLabel());
        });
    }
}

