/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.dict.annotation;

import cn.iosd.starter.dict.annotation.DictEntity;
import cn.iosd.starter.dict.annotation.DictField;
import cn.iosd.starter.dict.service.DictService;
import cn.iosd.starter.dict.vo.DictItem;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Aspect
@Component
public class DictAspect {
    private static final Logger log = LoggerFactory.getLogger(DictAspect.class);
    @Autowired
    private List<DictService> dictServiceList;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${simple.dict.dictImplBeanName:}")
    private String dictImplBeanName;
    private Map<String, DictService> dictServiceMap = new HashMap<String, DictService>();

    @PostConstruct
    public void init() {
        for (DictService service : this.dictServiceList) {
            String beanName = this.applicationContext.getBeanNamesForType(service.getClass())[0];
            this.dictServiceMap.put(beanName, service);
        }
    }

    public DictService getDictServiceByName(String name) {
        String serviceName = StringUtils.isNotBlank((CharSequence)name) ? name : this.dictImplBeanName;
        return this.dictServiceMap.getOrDefault(serviceName, this.dictServiceList.get(0));
    }

    @Around(value="@annotation(cn.iosd.starter.dict.annotation.Dict)")
    public Object translateDict(ProceedingJoinPoint joinPoint) throws Throwable {
        Object responseObj = joinPoint.proceed();
        this.translateDictObjects(responseObj, new HashMap<String, List<DictItem>>(16));
        return responseObj;
    }

    private void translateDictObjects(Object responseObj, Map<String, List<DictItem>> cache) throws IllegalAccessException {
        Field[] fields;
        if (responseObj instanceof List) {
            for (Object singleObj : (List)responseObj) {
                this.translateDictObjects(singleObj, cache);
            }
        }
        block1: for (Field field : fields = responseObj.getClass().getDeclaredFields()) {
            DictField dictFieldAnnotation = field.getAnnotation(DictField.class);
            if (dictFieldAnnotation != null) {
                DictService dictService = this.getDictServiceByName(dictFieldAnnotation.dictImplBeanName());
                List<DictItem> dictItemList = this.getCachedDictItemList(dictService, dictFieldAnnotation.dictionaryParams(), cache);
                if (dictItemList == null || dictItemList.size() == 0) {
                    log.error("\u83b7\u53d6\u5b57\u5178\u9879\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u7c7b\uff1a{} \u5b57\u5178\u53c2\u6570\uff1a{} \u670d\u52a1\u7c7b\u5305\u5730\u5740\uff1a{}", new Object[]{dictService.getClass().getSimpleName(), dictFieldAnnotation.dictionaryParams(), dictService.getClass().getPackageName()});
                    continue;
                }
                ReflectionUtils.makeAccessible((Field)field);
                Object fieldValue = field.get(responseObj);
                if (fieldValue == null) continue;
                String relatedField = dictFieldAnnotation.relatedField();
                for (DictItem dictItem : dictItemList) {
                    if (!String.valueOf(fieldValue).equals(dictItem.getValue())) continue;
                    Field related = ReflectionUtils.findField(responseObj.getClass(), (String)relatedField);
                    if (related == null) continue block1;
                    ReflectionUtils.makeAccessible((Field)related);
                    ReflectionUtils.setField((Field)related, (Object)responseObj, (Object)dictItem.getLabel());
                    continue block1;
                }
                continue;
            }
            if (!field.isAnnotationPresent(DictEntity.class)) continue;
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = field.get(responseObj);
            this.translateDictObjects(fieldValue, cache);
        }
    }

    private List<DictItem> getCachedDictItemList(DictService dictService, String dictParams, Map<String, List<DictItem>> cache) {
        List<DictItem> dictItemList = cache.get(dictParams);
        if (dictItemList == null) {
            dictItemList = dictService.getDictItemList(dictParams);
            cache.put(dictParams, dictItemList);
        }
        return dictItemList;
    }
}

