/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.dict.annotation;

import cn.iosd.starter.dict.annotation.DictEntity;
import cn.iosd.starter.dict.annotation.DictField;
import cn.iosd.starter.dict.service.DictService;
import cn.iosd.starter.dict.vo.DictItem;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Aspect
@Component
public class DictAspect {
    @Autowired
    private List<DictService> dictServiceList;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${simple.dict.dictImplBeanName:localDictServiceImpl}")
    private String dictImplBeanName;
    private Map<String, DictService> dictServiceMap = new HashMap<String, DictService>();

    @PostConstruct
    public void init() {
        for (DictService service : this.dictServiceList) {
            String beanName = this.applicationContext.getBeanNamesForType(service.getClass())[0];
            this.dictServiceMap.put(beanName, service);
        }
    }

    public DictService getDictServiceByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.dictServiceMap.get(this.dictImplBeanName);
        }
        return this.dictServiceMap.get(name);
    }

    @Around(value="@annotation(cn.iosd.starter.dict.annotation.Dict)")
    public Object translateDict(ProceedingJoinPoint joinPoint) throws Throwable {
        Object responseObj = joinPoint.proceed();
        this.translateDictObjects(responseObj, false, new HashMap<String, List<DictItem>>(16));
        return responseObj;
    }

    private void translateDictObjects(Object responseObj, boolean tempCacheEnabled, Map<String, List<DictItem>> cache) throws IllegalAccessException {
        Field[] fields;
        if (responseObj instanceof List) {
            for (Object singleObj : (List)responseObj) {
                this.translateDictObjects(singleObj, true, cache);
            }
        }
        block1: for (Field field : fields = responseObj.getClass().getDeclaredFields()) {
            DictField dictFieldAnnotation = field.getAnnotation(DictField.class);
            if (dictFieldAnnotation != null) {
                List<DictItem> dictItemList;
                DictService dictService = this.getDictServiceByName(dictFieldAnnotation.dictImplBeanName());
                if (dictService == null || (dictItemList = this.getCachedDictItemList(dictService, dictFieldAnnotation.dictionaryParams(), tempCacheEnabled, cache)) == null || dictItemList.size() == 0) continue;
                ReflectionUtils.makeAccessible((Field)field);
                Object fieldValue = field.get(responseObj);
                if (fieldValue == null) continue;
                String relatedField = dictFieldAnnotation.relatedField();
                for (DictItem dictItem : dictItemList) {
                    if (!String.valueOf(fieldValue).equals(dictItem.getValue())) continue;
                    Field related = ReflectionUtils.findField(responseObj.getClass(), (String)relatedField);
                    if (related == null) continue block1;
                    ReflectionUtils.makeAccessible((Field)related);
                    ReflectionUtils.setField((Field)related, (Object)responseObj, (Object)dictItem.getLabel());
                    continue block1;
                }
                continue;
            }
            if (!field.isAnnotationPresent(DictEntity.class)) continue;
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = field.get(responseObj);
            this.translateDictObjects(fieldValue, true, cache);
        }
    }

    private List<DictItem> getCachedDictItemList(DictService dictService, String dictionaryParams, boolean tempCacheEnabled, Map<String, List<DictItem>> cache) {
        List<DictItem> dictItemList = null;
        if (tempCacheEnabled) {
            dictItemList = cache.get(dictionaryParams);
        }
        if (dictItemList == null) {
            dictItemList = dictService.getDictItemList(dictionaryParams);
            if (tempCacheEnabled) {
                cache.put(dictionaryParams, dictItemList);
            }
        }
        return dictItemList;
    }
}

