/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.datasource.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;

@MappedJdbcTypes(value={JdbcType.JAVA_OBJECT})
@MappedTypes(value={String.class})
public class GeometryTypeHandler
extends BaseTypeHandler<String> {
    private final WKTReader wktReader = new WKTReader(new GeometryFactory(new PrecisionModel()));
    private final WKBWriter wkbWriter = new WKBWriter(2, 2, false);

    public void setNonNullParameter(PreparedStatement preparedStatement, int i, String s, JdbcType jdbcType) throws SQLException {
        try {
            Geometry geo = this.wktReader.read(s);
            byte[] geometryBytes = this.wkbWriter.write(geo);
            byte[] wkb = new byte[geometryBytes.length + 4];
            wkb[3] = 0;
            wkb[2] = 0;
            wkb[1] = 0;
            wkb[0] = 0;
            System.arraycopy(geometryBytes, 0, wkb, 4, geometryBytes.length);
            preparedStatement.setBytes(i, wkb);
        }
        catch (ParseException e) {
            throw new SQLException("Failed to parse geometry", e);
        }
    }

    public String getNullableResult(ResultSet resultSet, String s) throws SQLException {
        String string;
        block8: {
            InputStream inputStream = resultSet.getBinaryStream(s);
            try {
                String string2 = string = inputStream == null ? null : this.getGeometryAsString(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SQLException("Failed to get geometry", e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public String getNullableResult(ResultSet resultSet, int i) throws SQLException {
        String string;
        block8: {
            InputStream inputStream = resultSet.getBinaryStream(i);
            try {
                String string2 = string = inputStream == null ? null : this.getGeometryAsString(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SQLException("Failed to get geometry", e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public String getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        try {
            byte[] bytes = callableStatement.getBytes(i);
            return bytes == null ? null : this.getGeometryAsString(new ByteArrayInputStream(bytes));
        }
        catch (Exception e) {
            throw new SQLException("Failed to get geometry", e);
        }
    }

    private String getGeometryAsString(InputStream inputStream) throws Exception {
        int bytesRead;
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            ba.write(buffer, 0, bytesRead);
        }
        byte[] geometryAsBytes = ba.toByteArray();
        if (geometryAsBytes.length < 5) {
            throw new IllegalArgumentException("Failed to get geometry: Invalid geometry");
        }
        byte[] srIdBytes = new byte[4];
        System.arraycopy(geometryAsBytes, 0, srIdBytes, 0, 4);
        int srId = ByteOrderValues.getInt((byte[])geometryAsBytes, (int)0);
        WKBReader wkbReader = new WKBReader();
        byte[] wkb = new byte[geometryAsBytes.length - 4];
        System.arraycopy(geometryAsBytes, 4, wkb, 0, wkb.length);
        Geometry dbGeometry = wkbReader.read(wkb);
        dbGeometry.setSRID(srId);
        return dbGeometry.toString();
    }
}

