/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.datasource.base;

import cn.iosd.starter.datasource.utils.BaseUtils;
import cn.iosd.starter.web.base.ICrudService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class BaseServiceImpl<M extends BaseMapper<E>, E extends T, T>
extends ServiceImpl<M, E>
implements ICrudService<T> {
    @Autowired
    private M mapper;

    public T apiSave(T entity) {
        BaseUtils.setValue(entity, "setCreateTime", LocalDateTime.now(), LocalDateTime.class);
        this.mapper.insert(entity);
        return entity;
    }

    public T apiUpdateById(Long id, T entity) {
        BaseUtils.setValue(entity, "setId", id, Long.class);
        BaseUtils.setValue(entity, "setModifyTime", LocalDateTime.now(), LocalDateTime.class);
        this.mapper.updateById(entity);
        return null;
    }

    public Boolean apiRemoveById(Long id) {
        return this.mapper.deleteById((Serializable)id) > 0;
    }

    public T apiGetById(Long id) {
        return (T)this.mapper.selectById((Serializable)id);
    }

    public List<T> apiList(T req) {
        return this.mapper.selectList((Wrapper)Wrappers.lambdaQuery(req));
    }

    public Long apiCount(T req) {
        return this.mapper.selectCount((Wrapper)Wrappers.lambdaQuery(req));
    }
}

