/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.datasource.base;

import cn.iosd.starter.datasource.domain.PageRequest;
import cn.iosd.starter.datasource.utils.BaseUtils;
import cn.iosd.starter.web.base.CrudOperations;
import cn.iosd.starter.web.domain.Response;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.IService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class BaseController<T>
implements CrudOperations<T> {
    @Autowired
    private IService<T> service;

    @Operation(summary="Api-\u65b0\u589e")
    public Response<T> apiSave(@RequestBody T entity) {
        BaseUtils.setValue(entity, "setCreateTime", LocalDateTime.now(), LocalDateTime.class);
        this.service.save(entity);
        return Response.ok(entity);
    }

    @Operation(summary="Api-\u66f4\u65b0-Id")
    public Response<T> apiUpdateById(@PathVariable Long id, @RequestBody T entity) {
        BaseUtils.setValue(entity, "setId", id, Long.class);
        BaseUtils.setValue(entity, "setModifyTime", LocalDateTime.now(), LocalDateTime.class);
        this.service.updateById(entity);
        return Response.ok(entity);
    }

    @Operation(summary="Api-\u5220\u9664")
    public Response<Boolean> apiRemoveById(@PathVariable Long id) {
        return Response.ok((Object)this.service.removeById((Serializable)id));
    }

    @Operation(summary="Api-\u67e5\u8be2-\u5355\u4e2a")
    public Response<T> apiGetById(@PathVariable Long id) {
        return Response.ok((Object)this.service.getById((Serializable)id));
    }

    @Operation(summary="Api-\u67e5\u8be2-\u5217\u8868")
    public Response<List<T>> apiList(@ParameterObject T req) {
        return Response.ok((Object)this.service.list((Wrapper)Wrappers.lambdaQuery(req)));
    }

    @Operation(summary="Api-\u67e5\u8be2-\u7edf\u8ba1")
    public Response<Long> apiCount(@ParameterObject T req) {
        return Response.ok((Object)this.service.count((Wrapper)Wrappers.lambdaQuery(req)));
    }

    @Operation(summary="Api-\u67e5\u8be2-\u5206\u9875")
    @PostMapping(value={"/api/page"})
    public Response<IPage<T>> apiPage(@RequestBody PageRequest<T> req) {
        return Response.ok((Object)this.service.page(req.toPage(), req.toWrapper()));
    }
}

