/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.datasource.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class DatabaseInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInitializer.class);
    private static final String AUTO_CREATE_PROPERTY = "simple.datasource.autoCreateDatabase";
    private static final String URL_PROPERTY = "spring.datasource.dynamic.datasource.master.url";
    private static final String USERNAME_PROPERTY = "spring.datasource.dynamic.datasource.master.username";
    private static final String PASSWORD_PROPERTY = "spring.datasource.dynamic.datasource.master.password";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (this.shouldAutoCreateDatabase(applicationContext)) {
            String url = this.getPropertyValue(applicationContext, URL_PROPERTY);
            String username = this.getPropertyValue(applicationContext, USERNAME_PROPERTY);
            String password = this.getPropertyValue(applicationContext, PASSWORD_PROPERTY);
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{url, username, password})) {
                return;
            }
            this.initDatabase(url, username, password);
        }
    }

    private boolean shouldAutoCreateDatabase(ConfigurableApplicationContext applicationContext) {
        String autoCreate = this.getPropertyValue(applicationContext, AUTO_CREATE_PROPERTY);
        return StringUtils.isBlank((CharSequence)autoCreate) || Boolean.parseBoolean(autoCreate);
    }

    private void initDatabase(String url, String username, String password) {
        String mysql;
        String databaseName = this.parseDatabaseName(url);
        String urlSimplify = this.removeDatabaseName(url, databaseName);
        if (!urlSimplify.contains(mysql = ":mysql:")) {
            return;
        }
        log.info("Initializing database, Database Name: {}, Connection URL: {}", (Object)databaseName, (Object)urlSimplify);
        String createDataBaseSql = "create database if not exists `" + databaseName + "` DEFAULT CHARSET utf8mb4 COLLATE utf8mb4_general_ci";
        try (Connection conn = DriverManager.getConnection(urlSimplify, username, password);
             Statement stat = conn.createStatement();){
            stat.executeUpdate(createDataBaseSql);
        }
        catch (SQLException e) {
            log.error("Failed to create database: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String getPropertyValue(ConfigurableApplicationContext applicationContext, String propertyName) {
        return applicationContext.getEnvironment().getProperty(propertyName);
    }

    private String parseDatabaseName(String jdbcUrl) {
        if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
            throw new IllegalArgumentException("jdbcUrl is null or empty");
        }
        try {
            URI uri = new URI(jdbcUrl.substring(5));
            String path = uri.getPath();
            String databaseName = path.substring(1);
            if (StringUtils.isBlank((CharSequence)databaseName)) {
                throw new IllegalArgumentException("Cannot parse database name from jdbcUrl: " + jdbcUrl);
            }
            return databaseName;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot parse database name from jdbcUrl: " + jdbcUrl + ". Invalid URI syntax", e);
        }
    }

    private String removeDatabaseName(String jdbcUrl, String databaseName) {
        return jdbcUrl.replace("/" + databaseName, "");
    }
}

