/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.datasource.config;

import cn.iosd.starter.datasource.mybatis.provider.MapperLocationsProvider;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusPropertiesCustomizer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={MybatisPlusAutoConfiguration.class})
@ConditionalOnProperty(name={"simple.datasource.locations.enabled"}, havingValue="true")
public class MapperLocationsAutoConfiguration {
    @Autowired(required=false)
    private List<MapperLocationsProvider> providers;

    @Bean
    public MybatisPlusPropertiesCustomizer mybatisPlusPropertiesCustomizer() {
        return properties -> {
            ArrayList<String> mapperLocations = new ArrayList<String>();
            if (this.providers != null) {
                for (MapperLocationsProvider provider : this.providers) {
                    mapperLocations.addAll(provider.getMapperLocations());
                }
                properties.setMapperLocations(mapperLocations.toArray(new String[0]));
            }
        };
    }
}

