/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.datasource.mybatis.handler;

import cn.iosd.starter.web.utils.JsonUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class JacksonTypeHandler
extends BaseTypeHandler<JsonNode> {
    public void setNonNullParameter(PreparedStatement ps, int i, JsonNode parameter, JdbcType jdbcType) throws SQLException {
        String json = parameter.toString();
        ps.setString(i, json);
    }

    public JsonNode getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String json = rs.getString(columnName);
        if (json != null) {
            return this.read(json);
        }
        return null;
    }

    public JsonNode getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String json = rs.getString(columnIndex);
        if (json != null) {
            return this.read(json);
        }
        return null;
    }

    public JsonNode getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String json = cs.getString(columnIndex);
        if (json != null) {
            return this.read(json);
        }
        return null;
    }

    private JsonNode read(String json) {
        try {
            return JsonUtil.DEFAULT_INSTANCE.readTree(json);
        }
        catch (JsonParseException e) {
            return null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

