/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.datasource.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class DatabaseInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInitializer.class);
    private static volatile boolean RUN = false;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (!RUN) {
            String autoCreate = this.getPropertyValue(applicationContext, "simple.datasource.autoCreateDatabase");
            if (StringUtils.isBlank((CharSequence)autoCreate) || Boolean.parseBoolean(autoCreate)) {
                String password;
                String username;
                String url = this.getPropertyValue(applicationContext, "spring.datasource.dynamic.datasource.master.url");
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{url, username = this.getPropertyValue(applicationContext, "spring.datasource.dynamic.datasource.master.username"), password = this.getPropertyValue(applicationContext, "spring.datasource.dynamic.datasource.master.password")})) {
                    return;
                }
                this.initDatabase(url, username, password);
            }
            RUN = true;
        }
    }

    private String getPropertyValue(ConfigurableApplicationContext applicationContext, String propertyName) {
        return applicationContext.getEnvironment().getProperty(propertyName);
    }

    private void initDatabase(String url, String username, String password) {
        String database = this.parseDatabaseName(url);
        String urlSimplify = this.removeDatabaseName(url, database);
        log.info("AutoCreateDatabase\uff1a\u521d\u59cb\u5316\u6570\u636e\u5e93,\u6570\u636e\u5e93\u540d:{},\u8fde\u63a5\u5730\u5740:{} ", (Object)database, (Object)urlSimplify);
        String mysql = ":mysql:";
        String createDataBaseSql = "";
        if (urlSimplify.contains(mysql)) {
            createDataBaseSql = "create database if not exists `" + database + "` DEFAULT CHARSET utf8mb4 COLLATE utf8mb4_general_ci";
        }
        try (Connection conn = DriverManager.getConnection(urlSimplify, username, password);
             Statement stat = conn.createStatement();){
            stat.executeUpdate(createDataBaseSql);
        }
        catch (SQLException e) {
            log.error("\u521b\u5efa\u6570\u636e\u5e93\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    String parseDatabaseName(String jdbcUrl) {
        if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
            throw new IllegalArgumentException("jdbcUrl is null or empty");
        }
        try {
            URI uri = new URI(jdbcUrl.substring(5));
            String path = uri.getPath();
            String databaseName = path.substring(1);
            if (StringUtils.isBlank((CharSequence)databaseName)) {
                throw new IllegalArgumentException("can not parse database name from jdbcUrl: " + jdbcUrl);
            }
            return databaseName;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("can not parse database name from jdbcUrl: " + jdbcUrl + ". Invalid URI syntax", e);
        }
    }

    String removeDatabaseName(String jdbcUrl, String databaseName) {
        return jdbcUrl.replace("/" + databaseName, "");
    }
}

