/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.starter.datasource.base;

import cn.iosd.starter.datasource.domain.PageRequest;
import cn.iosd.starter.datasource.utils.DsConvertUtil;
import cn.iosd.starter.web.domain.Response;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.IService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.List;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class BaseController<T> {
    @Autowired
    private IService<T> service;

    @Operation(summary="Api-\u65b0\u589e")
    @PostMapping(value={"/api"})
    public Response<Boolean> apiSave(@RequestBody T entity) {
        this.setValue(entity, "setCreateTime", LocalDateTime.now(), LocalDateTime.class);
        return Response.ok((Object)this.service.save(entity));
    }

    @Operation(summary="Api-\u66f4\u65b0-Id")
    @PutMapping(value={"/api/{id}"})
    public Response<Boolean> apiUpdateById(@PathVariable Long id, @RequestBody T entity) {
        this.setValue(entity, "setId", id, Long.class);
        this.setValue(entity, "setModifyTime", LocalDateTime.now(), LocalDateTime.class);
        return Response.ok((Object)this.service.updateById(entity));
    }

    @Operation(summary="Api-\u5220\u9664")
    @DeleteMapping(value={"/api/{id}"})
    public Response<Boolean> apiRemoveById(@PathVariable Long id) {
        return Response.ok((Object)this.service.removeById((Serializable)id));
    }

    @Operation(summary="Api-\u67e5\u8be2-\u5355\u4e2a")
    @GetMapping(value={"/api/{id}"})
    public Response<T> apiGetById(@PathVariable Long id) {
        return Response.ok((Object)this.service.getById((Serializable)id));
    }

    @Operation(summary="Api-\u67e5\u8be2-\u5217\u8868")
    @GetMapping(value={"/api/list"})
    public Response<List<T>> apiList(@ParameterObject T req) {
        return Response.ok((Object)this.service.list((Wrapper)Wrappers.lambdaQuery(req)));
    }

    @Operation(summary="Api-\u67e5\u8be2-\u5206\u9875")
    @PostMapping(value={"/api/page"})
    public Response<IPage<T>> apiPage(@RequestBody PageRequest<T> req) {
        return Response.ok((Object)this.service.page(DsConvertUtil.page(req), (Wrapper)Wrappers.lambdaQuery(req.getData())));
    }

    private <V> void setValue(T entity, String methodName, V value, Class<V> valueType) {
        try {
            Method method = entity.getClass().getMethod(methodName, valueType);
            method.invoke(entity, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

