/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.s3.controller;

import cn.iosd.base.s3.domain.StorageObjectRequest;
import cn.iosd.base.s3.domain.StorageObjectResponse;
import cn.iosd.base.s3.service.SimpleStorageService;
import cn.iosd.starter.web.domain.Response;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectListing;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u5b58\u50a8\u670d\u52a1")
@RestController
@RequestMapping(value={"/simple-base-s3/storage"})
public class StorageController {
    @Autowired(required=false)
    private SimpleStorageService simpleStorageService;

    @Operation(summary="\u83b7\u53d6\u5b58\u50a8\u6876\u5217\u8868")
    @GetMapping(value={"/bucket/list"})
    public Response<List<Bucket>> getListBuckets(@Parameter(description="\u5b58\u50a8\u6876") String bucketName) {
        return Response.ok(this.simpleStorageService.getListBuckets(bucketName));
    }

    @Operation(summary="\u521b\u5efa\u5b58\u50a8\u6876")
    @GetMapping(value={"/bucket"})
    public Response<Bucket> creatBucket(@Parameter(description="\u5b58\u50a8\u6876") String bucketName) {
        return Response.ok((Object)this.simpleStorageService.creatBucket(bucketName));
    }

    @Operation(summary="\u5220\u9664\u5b58\u50a8\u6876")
    @DeleteMapping(value={"/bucket"})
    public Response<?> deleteBucket(@Parameter(description="\u5b58\u50a8\u6876") String bucketName) {
        this.simpleStorageService.deleteBucket(bucketName);
        return Response.ok();
    }

    @Operation(summary="\u83b7\u53d6\u6587\u4ef6\u5217\u8868-\u9996\u9875")
    @PostMapping(value={"/object"})
    public Response<StorageObjectResponse> getStorageObject(@RequestBody StorageObjectRequest storageObjectRequest) {
        return Response.ok((Object)this.simpleStorageService.getStorageObject(storageObjectRequest));
    }

    @Operation(summary="\u83b7\u53d6\u6587\u4ef6\u5217\u8868-\u4e0b\u4e00\u9875")
    @PostMapping(value={"/object/Next"})
    public Response<StorageObjectResponse> getStorageObjectNext(@Parameter(name="\u672c\u9875\u5bf9\u8c61\u5217\u8868\u4fe1\u606f") @RequestBody ObjectListing objectListing) {
        return Response.ok((Object)this.simpleStorageService.getStorageObjectNext(objectListing));
    }

    @Operation(summary="\u4e0a\u4f20\u6587\u4ef6-\u8fd4\u56de\u6587\u4ef6key")
    @PostMapping(value={"/object/upload"})
    public Response<String> upload(@ModelAttribute MultipartFile file, @Parameter(description="\u5b58\u50a8\u6876") String bucketName, @Parameter(description="\u6587\u4ef6\u540d\u540e\u7f00", example="png") String fileExtension) throws IOException {
        String fileKey = RandomStringUtils.randomAlphabetic((int)12) + "." + fileExtension;
        this.simpleStorageService.upload(file.getContentType(), file.getSize(), file.getInputStream(), bucketName, fileKey);
        return Response.ok((Object)fileKey);
    }

    @Operation(summary="\u751f\u6210\u5e26\u6709\u9884\u7b7e\u540d\u7684URL\uff0c\u7528\u4e8e\u79c1\u6709S3\u5bf9\u8c61\u7684\u8bbf\u95ee")
    @GetMapping(value={"/object/url"})
    public Response<String> generatePresignedUrl(@Parameter(description="\u5b58\u50a8\u6876") String bucketName, @Parameter(description="\u6587\u4ef6\u4e3b\u952e") String key) {
        return Response.ok((Object)this.simpleStorageService.generatePresignedUrl(bucketName, key));
    }

    @Operation(summary="\u5220\u9664\u6587\u4ef6")
    @DeleteMapping(value={"/object"})
    public Response<?> deleteStorageObject(@Parameter(description="\u5b58\u50a8\u6876") String bucketName, @Parameter(description="\u6587\u4ef6\u4e3b\u952e") String key) {
        this.simpleStorageService.deleteStorageObject(bucketName, key);
        return Response.ok();
    }
}

