/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.s3.service.impl;

import cn.iosd.base.s3.domain.StorageObjectRequest;
import cn.iosd.base.s3.domain.StorageObjectResponse;
import cn.iosd.base.s3.service.SimpleStorageService;
import cn.iosd.starter.s3.service.AmazonS3Service;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SimpleStorageServiceImpl
implements SimpleStorageService {
    @Autowired
    private AmazonS3Service amazonS3Service;

    @Override
    public void upload(String contentType, Long size, InputStream input, String bucket, String key) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(contentType);
        metadata.setContentLength(size.longValue());
        this.amazonS3Service.putObject(metadata, input, bucket, key);
    }

    @Override
    public String generatePresignedUrl(String bucket, String key) {
        return this.amazonS3Service.generatePresignedUrl(bucket, key).toString();
    }

    @Override
    public List<Bucket> getListBuckets(String bucketName) {
        return this.amazonS3Service.getListBuckets(bucketName);
    }

    @Override
    public Bucket creatBucket(String bucketName) {
        return this.amazonS3Service.createBucket(bucketName);
    }

    @Override
    public void deleteBucket(String bucketName) {
        this.amazonS3Service.deleteBucket(bucketName);
    }

    @Override
    public StorageObjectResponse getStorageObject(StorageObjectRequest sor) {
        return this.convertToSor(this.amazonS3Service.listObjects(sor.getBucketName(), sor.getPrefixFileName(), sor.getPageSize()));
    }

    @Override
    public StorageObjectResponse getStorageObjectNext(ObjectListing objectListing) {
        return this.convertToSor(this.amazonS3Service.listNextBatchOfObjects(objectListing));
    }

    public StorageObjectResponse convertToSor(ObjectListing objectListing) {
        StorageObjectResponse response = new StorageObjectResponse();
        response.setSummaries(objectListing.getObjectSummaries());
        response.setObjectListing(objectListing);
        return response;
    }

    @Override
    public void deleteStorageObject(String bucketName, String key) {
        this.amazonS3Service.deleteObject(bucketName, key);
    }
}

