/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.s3.api.feign;

import cn.iosd.base.s3.api.domain.StorageObjectRequest;
import cn.iosd.base.s3.api.domain.StorageObjectResponse;
import cn.iosd.starter.web.domain.Response;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectListing;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(name="simple-base-s3-service", contextId="baseS3Feign", path="/simple-base-s3-service/storage", url="${simple.feign.base.s3.url:}", primary=false)
public interface SimpleStorageFeign {
    @GetMapping(value={"/bucket/list"})
    public Response<List<Bucket>> getListBuckets(@RequestParam(value="bucketName") String var1);

    @GetMapping(value={"/bucket"})
    public Response<Bucket> creatBucket(@RequestParam(value="bucketName") String var1);

    @DeleteMapping(value={"/bucket"})
    public Response<?> deleteBucket(@RequestParam(value="bucketName") String var1);

    @PostMapping(value={"/object"})
    public Response<StorageObjectResponse> getStorageObject(@RequestBody StorageObjectRequest var1);

    @PostMapping(value={"/object/Next"})
    public Response<StorageObjectResponse> getStorageObjectNext(@RequestBody ObjectListing var1);

    @PostMapping(value={"/object/upload"}, consumes={"multipart/form-data"})
    public Response<String> uploadMultipartFile(@RequestPart MultipartFile var1, @RequestParam(value="bucketName") String var2);

    @GetMapping(value={"/object/url"})
    public Response<String> generatePresignedUrl(@RequestParam(value="bucketName") String var1, @RequestParam(value="key") String var2);

    @DeleteMapping(value={"/object"})
    public Response<?> deleteStorageObject(@RequestParam(value="bucketName") String var1, @RequestParam(value="key") String var2);
}

