/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.s3.api.service.impl;

import cn.iosd.base.s3.api.domain.StorageObjectRequest;
import cn.iosd.base.s3.api.domain.StorageObjectResponse;
import cn.iosd.base.s3.api.feign.SimpleStorageFeign;
import cn.iosd.base.s3.api.service.SimpleStorageService;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectListing;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SimpleStorageServiceFeignImpl
implements SimpleStorageService {
    @Autowired
    private SimpleStorageFeign simpleStorageFeign;

    @Override
    public String uploadMultipartFile(MultipartFile file, String bucket, String fileExtension) throws IOException {
        return (String)this.simpleStorageFeign.uploadMultipartFile(file, bucket, fileExtension).dataOrThrowExceptionIfNotSuccess();
    }

    @Override
    public String generatePresignedUrl(String bucket, String key) {
        return (String)this.simpleStorageFeign.generatePresignedUrl(bucket, key).dataOrThrowExceptionIfNotSuccess();
    }

    @Override
    public List<Bucket> getListBuckets(String bucketName) {
        return (List)this.simpleStorageFeign.getListBuckets(bucketName).dataOrThrowExceptionIfNotSuccess();
    }

    @Override
    public Bucket creatBucket(String bucketName) {
        return (Bucket)this.simpleStorageFeign.creatBucket(bucketName).dataOrThrowExceptionIfNotSuccess();
    }

    @Override
    public void deleteBucket(String bucketName) {
        this.simpleStorageFeign.deleteBucket(bucketName).throwExceptionIfNotSuccess();
    }

    @Override
    public StorageObjectResponse getStorageObject(StorageObjectRequest storageObjectRequest) {
        return (StorageObjectResponse)this.simpleStorageFeign.getStorageObject(storageObjectRequest).dataOrThrowExceptionIfNotSuccess();
    }

    @Override
    public StorageObjectResponse getStorageObjectNext(ObjectListing objectListing) {
        return (StorageObjectResponse)this.simpleStorageFeign.getStorageObjectNext(objectListing).dataOrThrowExceptionIfNotSuccess();
    }

    @Override
    public void deleteStorageObject(String bucketName, String key) {
        this.simpleStorageFeign.deleteStorageObject(bucketName, key).throwExceptionIfNotSuccess();
    }
}

