/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.param.utils;

import cn.iosd.base.param.vo.CodeValue;
import cn.iosd.utils.JsonMapper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ParamInitUtil {
    public static final TypeReference<List<CodeValue<?>>> CODE_VALUES_TYPE_REFERENCE = new TypeReference<List<CodeValue<?>>>(){};
    public static final String OPEN_SIMULATION_CODE = "openSimulation";
    public static final String CONTENT_DATA_CODE = "contentData";

    public static <T> T readValue(CodeValue<?> codeValueDto, Class<T> valueType) {
        return (T)JsonMapper.convertObject(codeValueDto.getValue(), valueType);
    }

    public static <T> T readValue(CodeValue<?> codeValueDto, TypeReference<T> valueTypeRef) {
        return (T)JsonMapper.convertObject(codeValueDto.getValue(), valueTypeRef);
    }

    public static <T> T getValueByCode(List<CodeValue<?>> codeValueList, String code, Class<T> valueType) {
        Map<String, Object> codeValueMap = codeValueList.stream().collect(Collectors.toMap(CodeValue::getCode, CodeValue::getValue));
        return (T)JsonMapper.convertObject(codeValueMap.getOrDefault(code, null), valueType);
    }

    public static Optional<CodeValue<?>> getCodeValueByCode(List<CodeValue<?>> codeValueList, String code) {
        return codeValueList.stream().filter(v -> v.getCode().equals(code)).findFirst();
    }

    public static boolean getBooleanValueByCodeDefaultFalse(List<CodeValue<?>> codeValueList, String code) {
        return ParamInitUtil.getCodeValueByCode(codeValueList, code).map(CodeValue::getValue).map(Boolean.class::cast).orElse(false);
    }

    public static boolean getBooleanValueByOpenSimulationCodeDefaultFalse(List<CodeValue<?>> codeValueList) {
        return ParamInitUtil.getBooleanValueByCodeDefaultFalse(codeValueList, OPEN_SIMULATION_CODE);
    }
}

