/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.param.controller;

import cn.iosd.base.param.domain.BaseParam;
import cn.iosd.base.param.service.IBaseParamService;
import cn.iosd.base.param.vo.BaseParamVo;
import cn.iosd.starter.datasource.domain.PageRequest;
import cn.iosd.starter.datasource.utils.DsConvertUtil;
import cn.iosd.starter.web.domain.Response;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.IService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u57fa\u7840\u53c2\u6570\u914d\u7f6e")
@RestController
@RequestMapping(value={"/param"})
public class BaseParamController {
    @Autowired
    private IBaseParamService baseParamService;
    @Autowired
    private IService<BaseParam> service;

    @Operation(summary="\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/info"})
    public Response<BaseParam> getInfo(Long id, String paramKey) {
        return Response.ok((Object)(id != null ? this.baseParamService.selectBaseParamById(id) : this.baseParamService.selectBaseParamByKey(paramKey)));
    }

    @Operation(summary="\u65b0\u589e")
    @PostMapping
    public Response<Integer> add(@RequestBody BaseParamVo baseParamVo) {
        return Response.ok((Object)this.baseParamService.insertBaseParam(baseParamVo));
    }

    @Operation(summary="\u4fee\u6539")
    @PutMapping
    public Response<Integer> edit(@RequestBody BaseParamVo baseParamVo) {
        return Response.ok((Object)this.baseParamService.updateBaseParam(baseParamVo));
    }

    @Operation(summary="Api-\u5220\u9664")
    @DeleteMapping(value={"/api/{id}"})
    public Response<Boolean> apiRemoveById(@PathVariable Long id) {
        return Response.ok((Object)this.service.removeById((Serializable)id));
    }

    @Operation(summary="Api-\u67e5\u8be2-\u5355\u4e2a")
    @GetMapping(value={"/api/{id}"})
    public Response<BaseParam> apiGetById(@PathVariable Long id) {
        return Response.ok((Object)((BaseParam)this.service.getById((Serializable)id)));
    }

    @Operation(summary="Api-\u67e5\u8be2-\u5217\u8868")
    @GetMapping(value={"/api/list"})
    public Response<List<BaseParam>> apiList(@ParameterObject BaseParam req) {
        return Response.ok((Object)this.service.list((Wrapper)Wrappers.lambdaQuery((Object)req)));
    }

    @Operation(summary="Api-\u67e5\u8be2-\u5206\u9875")
    @PostMapping(value={"/api/page"})
    public Response<IPage<BaseParam>> apiPage(@RequestBody PageRequest<BaseParam> req) {
        return Response.ok((Object)this.service.page((IPage)DsConvertUtil.page(req), (Wrapper)Wrappers.lambdaQuery((Object)((BaseParam)req.getData()))));
    }
}

