/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.param.service.impl;

import cn.iosd.base.param.domain.BaseParam;
import cn.iosd.base.param.mapper.BaseParamMapper;
import cn.iosd.base.param.service.IBaseParamService;
import cn.iosd.base.param.utils.ParamInitUtil;
import cn.iosd.base.param.vo.BaseParamCodeValueVo;
import cn.iosd.base.param.vo.BaseParamSaveReqVo;
import cn.iosd.starter.web.utils.JsonMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BaseParamServiceImpl
extends ServiceImpl<BaseParamMapper, BaseParam>
implements IBaseParamService {
    @Override
    public BaseParam selectBaseParamById(Long id) {
        return (BaseParam)((BaseParamMapper)this.baseMapper).selectById(id);
    }

    @Override
    public BaseParam selectBaseParamByKey(String paramKey) {
        BaseParam baseParam = new BaseParam();
        baseParam.setParamKey(paramKey);
        return (BaseParam)((BaseParamMapper)this.baseMapper).selectOne((Wrapper)Wrappers.lambdaQuery((Object)baseParam));
    }

    @Override
    public List<BaseParamCodeValueVo<?>> selectCodeValueVoParamByKey(String paramKey) {
        BaseParam baseParam = this.selectBaseParamByKey(paramKey);
        return (List)JsonMapper.convertObject((Object)baseParam.getCodeValues(), ParamInitUtil.CODE_VALUES_TYPE_REFERENCE);
    }

    @Override
    public int insertBaseParam(BaseParamSaveReqVo baseParamVo) {
        BaseParam baseParam = this.convertBaseParam(baseParamVo);
        LocalDateTime now = LocalDateTime.now();
        baseParam.setCreateTime(now);
        baseParam.setModifyTime(now);
        baseParam.setHistoryCodeValues(this.inputHistoryCodeValues(baseParam.getCodeValues(), null));
        return ((BaseParamMapper)this.baseMapper).insert(baseParam);
    }

    @Override
    public int updateBaseParam(BaseParamSaveReqVo baseParamVo) {
        BaseParam baseParam = this.convertBaseParam(baseParamVo);
        LocalDateTime now = LocalDateTime.now();
        baseParam.setModifyTime(now);
        JsonNode historyCodeValues = null;
        if (baseParamVo.getId() != null) {
            historyCodeValues = ((BaseParam)((BaseParamMapper)this.baseMapper).selectById(baseParamVo.getId())).getHistoryCodeValues();
        }
        baseParam.setHistoryCodeValues(this.inputHistoryCodeValues(baseParam.getCodeValues(), historyCodeValues));
        return ((BaseParamMapper)this.baseMapper).updateById(baseParam);
    }

    public BaseParam convertBaseParam(BaseParamSaveReqVo baseParamVo) {
        BaseParam baseParam = new BaseParam();
        JsonNode moduleNames = (JsonNode)JsonMapper.convertObject(baseParamVo.getModuleNames(), JsonNode.class);
        JsonNode codeValues = (JsonNode)JsonMapper.convertObject(baseParamVo.getCodeValues(), JsonNode.class);
        baseParam.setId(baseParamVo.getId());
        baseParam.setModuleNames(moduleNames);
        baseParam.setCodeValues(codeValues);
        baseParam.setRemark(baseParamVo.getRemark());
        baseParam.setParamKey(baseParamVo.getParamKey());
        return baseParam;
    }

    public JsonNode inputHistoryCodeValues(JsonNode codeValues, JsonNode historyCodeValues) {
        ArrayList<Object> subNodes = new ArrayList<Object>();
        if (historyCodeValues != null && historyCodeValues.isArray()) {
            for (JsonNode objNode : historyCodeValues) {
                subNodes.add(objNode);
            }
        }
        ObjectNode codeValuesObject = new ObjectNode(JsonNodeFactory.instance);
        codeValuesObject.set("codeValues", codeValues);
        codeValuesObject.put("createTime", Timestamp.valueOf(LocalDateTime.now()).getTime());
        subNodes.add(codeValuesObject);
        return new ArrayNode(JsonNodeFactory.instance, subNodes.size() > 10 ? subNodes.subList(subNodes.size() - 10, subNodes.size()) : subNodes);
    }
}

