/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.param.init;

import cn.iosd.base.param.domain.BaseParam;
import cn.iosd.base.param.init.ParamInit;
import cn.iosd.base.param.service.IBaseParamService;
import cn.iosd.base.param.vo.BaseParamSaveReqVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Component;

@Component
public class ParamInitLifecycle
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(ParamInitLifecycle.class);
    @Autowired(required=false)
    private List<ParamInit> paramInits;
    @Autowired
    private IBaseParamService baseParamService;
    private static boolean RUNNING = false;

    public void start() {
        if (!this.isRunning()) {
            RUNNING = true;
            this.init();
        }
    }

    public void stop() {
    }

    public boolean isRunning() {
        return RUNNING;
    }

    public void init() {
        if (this.paramInits != null) {
            this.paramInits.forEach(v -> {
                String key = v.getKey();
                if (key == null || "".equals(key)) {
                    throw new IllegalArgumentException("\u521d\u59cb\u5316key\u503c\u4e3a\u7a7a");
                }
                try {
                    BaseParam baseParam = this.baseParamService.selectBaseParamByKey(key);
                    if (baseParam == null) {
                        this.baseParamService.insertBaseParam(this.initVo((ParamInit)v));
                    } else if (v.restartOverride()) {
                        BaseParamSaveReqVo saveReqVo = this.initVo((ParamInit)v);
                        saveReqVo.setId(baseParam.getId());
                        this.baseParamService.updateBaseParam(saveReqVo);
                    }
                }
                catch (Exception e) {
                    log.error("\u53c2\u6570[{}]\u521d\u59cb\u5316\u5931\u8d25:{}", (Object)key, (Object)e.getMessage());
                }
            });
        }
    }

    public BaseParamSaveReqVo initVo(ParamInit service) {
        BaseParamSaveReqVo vo = new BaseParamSaveReqVo();
        vo.setCodeValues(service.getCodeValues());
        vo.setModuleNames(service.getModuleNames());
        vo.setParamKey(service.getKey());
        vo.setRemark(service.getRemark());
        return vo;
    }
}

