/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.param.service.impl;

import cn.iosd.base.param.domain.BaseParam;
import cn.iosd.base.param.mapper.BaseParamMapper;
import cn.iosd.base.param.service.IBaseParamService;
import cn.iosd.base.param.utils.ParamInitUtil;
import cn.iosd.base.param.vo.BaseParamCodeValueVo;
import cn.iosd.base.param.vo.BaseParamListReqVo;
import cn.iosd.base.param.vo.BaseParamSaveReqVo;
import cn.iosd.starter.web.utils.JsonUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseParamServiceImpl
implements IBaseParamService {
    @Autowired
    private BaseParamMapper baseParamMapper;

    @Override
    public BaseParam selectBaseParamById(Long id) {
        return this.baseParamMapper.selectBaseParamById(id);
    }

    @Override
    public BaseParam selectBaseParamByKey(String paramKey) {
        return this.baseParamMapper.selectBaseParamByKey(paramKey);
    }

    @Override
    public List<BaseParamCodeValueVo<?>> selectCodeValueVoParamByKey(String paramKey) throws JsonProcessingException {
        BaseParam baseParam = this.baseParamMapper.selectBaseParamByKey(paramKey);
        return (List)JsonUtil.convertObject((Object)baseParam.getCodeValues(), ParamInitUtil.CODE_VALUES_TYPE_REFERENCE);
    }

    @Override
    public List<BaseParam> selectBaseParamList(BaseParamListReqVo baseParam) {
        return this.baseParamMapper.selectBaseParamList(baseParam);
    }

    @Override
    public Long insertBaseParam(BaseParamSaveReqVo baseParamVo) throws JsonProcessingException {
        BaseParam baseParam = this.convertBaseParam(baseParamVo);
        LocalDateTime now = LocalDateTime.now();
        baseParam.setCreateTime(now);
        baseParam.setModifyTime(now);
        baseParam.setHistoryCodeValues(this.inputHistoryCodeValues(baseParam.getCodeValues(), null));
        this.baseParamMapper.insertBaseParam(baseParam);
        return baseParam.getId();
    }

    @Override
    public int updateBaseParam(BaseParamSaveReqVo baseParamVo) throws JsonProcessingException {
        BaseParam baseParam = this.convertBaseParam(baseParamVo);
        LocalDateTime now = LocalDateTime.now();
        baseParam.setModifyTime(now);
        JsonNode historyCodeValues = null;
        if (baseParamVo.getId() != null) {
            historyCodeValues = this.baseParamMapper.selectBaseParamById(baseParamVo.getId()).getHistoryCodeValues();
        }
        baseParam.setHistoryCodeValues(this.inputHistoryCodeValues(baseParam.getCodeValues(), historyCodeValues));
        return this.baseParamMapper.updateBaseParam(baseParam);
    }

    public BaseParam convertBaseParam(BaseParamSaveReqVo baseParamVo) throws JsonProcessingException {
        BaseParam baseParam = new BaseParam();
        JsonNode moduleNames = (JsonNode)JsonUtil.convertObject(baseParamVo.getModuleNames(), JsonNode.class);
        JsonNode codeValues = (JsonNode)JsonUtil.convertObject(baseParamVo.getCodeValues(), JsonNode.class);
        baseParam.setId(baseParamVo.getId());
        baseParam.setModuleNames(moduleNames);
        baseParam.setCodeValues(codeValues);
        baseParam.setRemark(baseParamVo.getRemark());
        baseParam.setParamKey(baseParamVo.getParamKey());
        return baseParam;
    }

    public JsonNode inputHistoryCodeValues(JsonNode codeValues, JsonNode historyCodeValues) {
        ArrayList<Object> subNodes = new ArrayList<Object>();
        if (historyCodeValues != null && historyCodeValues.isArray()) {
            for (JsonNode objNode : historyCodeValues) {
                subNodes.add(objNode);
            }
        }
        ObjectNode codeValuesObject = new ObjectNode(JsonNodeFactory.instance);
        codeValuesObject.set("codeValues", codeValues);
        codeValuesObject.put("createTime", Timestamp.valueOf(LocalDateTime.now()).getTime());
        subNodes.add(codeValuesObject);
        return new ArrayNode(JsonNodeFactory.instance, subNodes.size() > 10 ? subNodes.subList(subNodes.size() - 10, subNodes.size()) : subNodes);
    }

    @Override
    public int deleteBaseParamByIds(Long[] ids) {
        return this.baseParamMapper.deleteBaseParamByIds(ids);
    }

    @Override
    public int deleteBaseParamById(Long id) {
        return this.baseParamMapper.deleteBaseParamById(id);
    }
}

