/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.param.utils;

import cn.iosd.base.param.vo.BaseParamCodeValueVo;
import cn.iosd.utils.JsonMapper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ParamInitUtil {
    public static final TypeReference<List<BaseParamCodeValueVo<?>>> CODE_VALUES_TYPE_REFERENCE = new TypeReference<List<BaseParamCodeValueVo<?>>>(){};
    public static final String OPEN_SIMULATION_CODE = "openSimulation";
    public static final String CONTENT_DATA_CODE = "contentData";

    public static <T> T readValue(BaseParamCodeValueVo<?> paramSingleCodeValueDto, Class<T> valueType) {
        return (T)JsonMapper.convertObject(paramSingleCodeValueDto.getValue(), valueType);
    }

    public static <T> T readValue(BaseParamCodeValueVo<?> paramSingleCodeValueDto, TypeReference<T> valueTypeRef) {
        return (T)JsonMapper.convertObject(paramSingleCodeValueDto.getValue(), valueTypeRef);
    }

    public static <T> T getValueByCode(List<BaseParamCodeValueVo<?>> simulation, String code, Class<T> valueType) {
        Map<String, Object> codeValueMap = simulation.stream().collect(Collectors.toMap(BaseParamCodeValueVo::getCode, BaseParamCodeValueVo::getValue));
        return (T)JsonMapper.convertObject(codeValueMap.getOrDefault(code, null), valueType);
    }

    public static Optional<BaseParamCodeValueVo<?>> getBaseParamCodeValueVoByCode(List<BaseParamCodeValueVo<?>> simulation, String code) {
        return simulation.stream().filter(v -> v.getCode().equals(code)).findFirst();
    }

    public static boolean getBooleanValueByCodeDefaultFalse(List<BaseParamCodeValueVo<?>> simulation, String code) {
        return ParamInitUtil.getBaseParamCodeValueVoByCode(simulation, code).map(BaseParamCodeValueVo::getValue).map(Boolean.class::cast).orElse(false);
    }
}

