/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.param.init;

import cn.iosd.base.param.domain.BaseParam;
import cn.iosd.base.param.init.ParamInit;
import cn.iosd.base.param.service.IBaseParamService;
import cn.iosd.base.param.vo.BaseParamSaveReqVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Component;

@Component
public class ParamInitLifecycle
implements SmartLifecycle {
    @Autowired(required=false)
    private List<ParamInit> inits;
    @Autowired
    private IBaseParamService baseParamService;
    private static boolean RUNNING = false;

    public void start() {
        if (!this.isRunning()) {
            RUNNING = true;
            this.init();
        }
    }

    public void stop() {
    }

    public boolean isRunning() {
        return RUNNING;
    }

    public void init() {
        if (this.inits != null) {
            this.inits.forEach(init -> {
                String key = init.getKey();
                if (StringUtils.isEmpty((CharSequence)key)) {
                    throw new IllegalArgumentException("\u521d\u59cb\u5316key\u503c\u4e3a\u7a7a");
                }
                this.initParam((ParamInit)init);
            });
        }
    }

    private void initParam(ParamInit init) {
        String key = init.getKey();
        BaseParam baseParam = this.baseParamService.selectBaseParamByKey(key);
        if (baseParam == null) {
            this.baseParamService.insertBaseParam(this.initVo(init));
        } else if (init.restartOverride()) {
            BaseParamSaveReqVo saveReqVo = this.initVo(init);
            saveReqVo.setId(baseParam.getId());
            this.baseParamService.updateBaseParam(saveReqVo);
        }
    }

    public BaseParamSaveReqVo initVo(ParamInit init) {
        BaseParamSaveReqVo vo = new BaseParamSaveReqVo();
        vo.setCodeValues(init.getCodeValues());
        vo.setModuleNames(init.getModuleNames());
        vo.setParamKey(init.getKey());
        vo.setRemark(init.getRemark());
        return vo;
    }
}

