/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.generator.service;

import cn.iosd.base.generator.vo.ProjectGenVo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
public class ProjectGenService {
    private static final Logger log = LoggerFactory.getLogger(ProjectGenService.class);
    @Value(value="${simple.base.generator.project.initProjectZipUrl:/temp/initProject.zip}")
    private String initProjectZipUrl;
    @Value(value="${simple.base.generator.project.newProjectAndZipTempPath:/temp/simple/new}")
    private String newProjectAndZipTempPath;

    public synchronized FileSystemResource projectGenZip(ProjectGenVo req) throws IOException {
        String projectName = req.getProjectName();
        String initUnzipPath = this.newProjectAndZipTempPath + "/init";
        String copyUnzipPath = this.newProjectAndZipTempPath + "/new";
        String successProjectPath = this.newProjectAndZipTempPath + "/new/" + projectName;
        String createZipPath = this.newProjectAndZipTempPath + "/project-" + projectName + ".zip";
        log.info("\u9879\u76ee\u540d\u79f0:{}---\u538b\u7f29\u5305:{},\u89e3\u538b\u81f3\u76ee\u5f55:{}", new Object[]{projectName, this.initProjectZipUrl, initUnzipPath});
        ProjectGenService.unzip(this.initProjectZipUrl, initUnzipPath);
        log.info("\u9879\u76ee\u540d\u79f0:{}---\u590d\u5236\u521d\u59cb\u5316\u76ee\u5f55\u5230\u65b0\u7684\u76ee\u5f55\u5730\u5740,\u4ee5\u5907\u8986\u76d6\u5185\u5bb9,\u521d\u59cb\u5316\u76ee\u5f55\u5730\u5740:{},\u65b0\u76ee\u5f55\u5730\u5740\u4e3a:{}", new Object[]{projectName, initUnzipPath, copyUnzipPath});
        this.copyInitProjectFiles(initUnzipPath, copyUnzipPath, req);
        log.info("\u9879\u76ee\u540d\u79f0:{}---\u5728\u6307\u5b9a\u6587\u4ef6\u5939\u4e2d\u9012\u5f52\u5730\u66ff\u6362\u53d8\u91cf\u7684\u503c,\u6307\u5b9a\u6587\u4ef6\u5939\u4e3a:{}", (Object)projectName, (Object)copyUnzipPath);
        this.replaceVariableValues(copyUnzipPath, req);
        log.info("\u9879\u76ee\u540d\u79f0:{}---\u521b\u5efa\u538b\u7f29\u5305,\u5b8c\u6210\u5185\u5bb9\u8986\u76d6\u7684\u76ee\u5f55\u5730\u5740:{},\u538b\u7f29\u5305\u5730\u5740:{}", new Object[]{projectName, successProjectPath, createZipPath});
        this.createZip(successProjectPath, createZipPath);
        log.info("\u9879\u76ee\u540d\u79f0:{}---\u5220\u9664\u538b\u7f29\u5305\u89e3\u538b\u76ee\u5f55\u53ca\u76ee\u5f55\u4e0b\u6587\u4ef6:{}", (Object)projectName, (Object)initUnzipPath);
        ProjectGenService.deleteFolder(new File(initUnzipPath));
        log.info("\u9879\u76ee\u540d\u79f0:{}---\u5220\u9664\u590d\u5236\u89e3\u538b\u540e\u7684\u5185\u5bb9\u5730\u5740\u53ca\u76ee\u5f55\u4e0b\u6587\u4ef6:{}", (Object)projectName, (Object)copyUnzipPath);
        ProjectGenService.deleteFolder(new File(copyUnzipPath));
        log.info("\u9879\u76ee\u540d\u79f0:{}---\u7559\u5b58\u538b\u7f29\u5305\u5730\u5740,\u4ee5\u4f9b\u4e0b\u8f7d,\u53ef\u5b9a\u671f\u6e05\u7406:{}", (Object)projectName, (Object)createZipPath);
        return new FileSystemResource(createZipPath);
    }

    private void copyInitProjectFiles(String initProjectPath, String newProjectPath, ProjectGenVo req) throws IOException {
        File initProject = new File(initProjectPath);
        File newProjectDir = new File(newProjectPath);
        this.copyFilesRecursively(initProject, newProjectDir, req);
    }

    private void copyFilesRecursively(File source, File destination, ProjectGenVo req) throws IOException {
        if (source.isDirectory()) {
            if (!destination.exists()) {
                destination.mkdirs();
            }
            for (String file : Objects.requireNonNull(source.list())) {
                File sourceFile = new File(source, file);
                File destFile = new File(destination, this.replaceVariables(file, req));
                this.copyFilesRecursively(sourceFile, destFile, req);
            }
        } else {
            try (FileInputStream in = new FileInputStream(source);
                 FileOutputStream out = new FileOutputStream(destination);){
                FileCopyUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
    }

    private void replaceVariableValues(String directoryPath, ProjectGenVo req) throws IOException {
        File directory = new File(directoryPath);
        for (File file : Objects.requireNonNull(directory.listFiles())) {
            if (file.isDirectory()) {
                this.replaceVariableValues(file.getAbsolutePath(), req);
                continue;
            }
            String content = this.readFileToString(file);
            content = this.replaceVariables(content, req);
            this.writeStringToFile(file, content);
        }
    }

    private String readFileToString(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line).append(System.lineSeparator());
            }
            String string = content.toString();
            return string;
        }
    }

    private void writeStringToFile(File file, String content) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
    }

    private String replaceVariables(String content, ProjectGenVo req) {
        String projectName = req.getProjectName();
        String packageName = req.getPackageName();
        String moduleName = req.getModuleName();
        String simpleVersion = req.getSimpleVersion();
        String springBootVersion = req.getSpringBootVersion();
        String javaVersion = req.getJavaVersion();
        return content.replace("{projectName}", projectName).replace("{packageName}", packageName).replace("{moduleName}", moduleName).replace("{simpleVersion}", simpleVersion).replace("{moduleNameCapitalized}", req.getModuleNameCapitalizedCustom()).replace("{packageDir}", req.getPackageDirCustom()).replace("{springBootVersion}", springBootVersion).replace("{javaVersion}", javaVersion);
    }

    private void createZip(String sourcePath, String zipFilePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zipOut = new ZipOutputStream(fos);){
            File sourceDir = new File(sourcePath);
            this.zipFile(sourceDir, sourceDir.getName(), zipOut);
        }
    }

    private void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            for (File childFile : Objects.requireNonNull(fileToZip.listFiles())) {
                this.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        try (FileInputStream fis = new FileInputStream(fileToZip);){
            int length;
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
        }
    }

    public static void unzip(String zipFilePath, String destinationFolderPath) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFilePath));){
            byte[] buffer = new byte[1024];
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                String filePath = destinationFolderPath + File.separator + entryName;
                if (zipEntry.isDirectory()) {
                    File dir = new File(filePath);
                    dir.mkdirs();
                } else {
                    File outputFile = new File(filePath);
                    File parentDir = outputFile.getParentFile();
                    if (parentDir != null) {
                        parentDir.mkdirs();
                    }
                    try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                        int bytesRead;
                        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                    }
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    public static void deleteFolder(File folder) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                ProjectGenService.deleteFolder(file);
            }
        }
        folder.delete();
    }
}

