/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.generator.service;

import cn.iosd.base.generator.vo.DatabaseGenVo;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.builder.CustomFile;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class DatabaseGenService {
    private static final String OUTPUT_DIR_PREFIX = "./target/generator";
    private static final String TEMPLATES_DIR_TEMPLATES_API = "/templates/api/";
    private static final String TEMPLATES_DIR_TEMPLATES_SERVICE = "/templates/service/";
    private static final String TEMPLATES_DIR_TEMPLATES_API_DOMAIN = "/templates/api/domain.java";
    private static final String TEMPLATES_DIR_TEMPLATES_API_FEIGN = "/templates/api/feign.java.ftl";
    private static final String TEMPLATES_DIR_TEMPLATES_API_SERVICE = "/templates/api/service.java";
    private static final String TEMPLATES_DIR_TEMPLATES_API_SERVICE_IMPL = "/templates/api/serviceImpl.java.ftl";
    private static final String TEMPLATES_DIR_TEMPLATES_SERVICE_CONTROLLER = "/templates/service/controller.java";
    private static final String TEMPLATES_DIR_TEMPLATES_SERVICE_MAPPER_JAVA = "/templates/service/mapper.java";
    private static final String TEMPLATES_DIR_TEMPLATES_SERVICE_MAPPER_XML = "/templates/service/mapper.xml";
    private static final String TEMPLATES_DIR_TEMPLATES_SERVICE_SERVICE_IMPL = "/templates/service/serviceImpl.java";
    private static final String TEMPLATES_DIR_TEMPLATES_SERVICE_ENTITY = "/templates/service/entity.java.ftl";

    public static void generate(DatabaseGenVo vo) {
        String moduleName = vo.getModuleName();
        String packageName = vo.getPackageName();
        String outputDirPrefixReal = OUTPUT_DIR_PREFIX.replace("/", File.separator);
        String outputDirModule = String.join((CharSequence)File.separator, outputDirPrefixReal, vo.getPackageName().replace(".", File.separator), vo.getModuleName()) + File.separator;
        String outputDirModuleApi = outputDirModule + "api" + File.separator;
        String outputDirModuleService = outputDirModule + "service" + File.separator;
        String outputDirModuleApiEntity = outputDirModuleApi + "domain";
        String outputDirModuleApiService = outputDirModuleApi + "service";
        String outputDirModuleApiFeign = outputDirModuleApi + "feign";
        String outputDirModuleApiServiceImpl = outputDirModuleApi + "service" + File.separator + "impl";
        String outputDirModuleServiceController = outputDirModuleService + "controller";
        String outputDirModuleServiceMapper = outputDirModuleService + "mapper";
        String outputDirModuleServiceMapperXml = outputDirModuleService + "mapper" + File.separator + "xml";
        String outputDirModuleServiceService = outputDirModuleService + "service";
        String outputDirModuleServiceEntity = outputDirModuleService + "entity";
        HashMap<OutputFile, CallSite> pathInfo = new HashMap<OutputFile, CallSite>(16);
        pathInfo.put(OutputFile.xml, (CallSite)((Object)outputDirModuleServiceMapperXml));
        pathInfo.put(OutputFile.controller, (CallSite)((Object)outputDirModuleServiceController));
        pathInfo.put(OutputFile.entity, (CallSite)((Object)outputDirModuleApiEntity));
        pathInfo.put(OutputFile.mapper, (CallSite)((Object)outputDirModuleServiceMapper));
        pathInfo.put(OutputFile.service, (CallSite)((Object)outputDirModuleApiService));
        pathInfo.put(OutputFile.serviceImpl, (CallSite)((Object)outputDirModuleServiceService));
        String packageParent = packageName + "." + moduleName;
        HashMap<String, Object> customMap = new HashMap<String, Object>(3);
        customMap.put("packageParent", packageParent);
        customMap.put("projectName", vo.getProjectName());
        ArrayList<CustomFile> customFiles = new ArrayList<CustomFile>();
        customFiles.add(new CustomFile.Builder().fileName("Feign.java").templatePath(TEMPLATES_DIR_TEMPLATES_API_FEIGN).filePath(outputDirModuleApiFeign).enableFileOverride().build());
        customFiles.add(new CustomFile.Builder().fileName("ServiceFeignImpl.java").templatePath(TEMPLATES_DIR_TEMPLATES_API_SERVICE_IMPL).filePath(outputDirModuleApiServiceImpl).enableFileOverride().build());
        customFiles.add(new CustomFile.Builder().fileName("Entity.java").templatePath(TEMPLATES_DIR_TEMPLATES_SERVICE_ENTITY).filePath(outputDirModuleServiceEntity).enableFileOverride().build());
        FastAutoGenerator.create((String)vo.getDataBaseUrl(), (String)vo.getDataBaseUserName(), (String)vo.getDataBasePassword()).globalConfig(builder -> builder.author(vo.getAuthorName()).enableSpringdoc().outputDir(outputDirPrefixReal).disableOpenDir()).packageConfig(builder -> builder.parent(packageName).moduleName(moduleName).xml("mapper").pathInfo(pathInfo)).strategyConfig(builder -> {
            builder.addInclude(vo.getTableNames());
            if (vo.getTablePrefix() != null) {
                builder.addTablePrefix(vo.getTablePrefix());
            }
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine()).templateConfig(builder -> {
            builder.controller(TEMPLATES_DIR_TEMPLATES_SERVICE_CONTROLLER);
            builder.mapper(TEMPLATES_DIR_TEMPLATES_SERVICE_MAPPER_JAVA);
            builder.xml(TEMPLATES_DIR_TEMPLATES_SERVICE_MAPPER_XML);
            builder.service(TEMPLATES_DIR_TEMPLATES_API_SERVICE);
            builder.serviceImpl(TEMPLATES_DIR_TEMPLATES_SERVICE_SERVICE_IMPL);
            builder.entity(TEMPLATES_DIR_TEMPLATES_API_DOMAIN);
        }).injectionConfig(builder -> {
            builder.customMap(customMap);
            builder.customFile(customFiles);
        }).execute();
    }
}

