/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.generator.database;

import cn.iosd.base.generator.vo.MybatisGeneratorVo;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class MybatisGenerator {
    private static final String SIMPLE_VERSION = "2023.2.3.0";
    private static final String OUTPUT_DIR_PREFIX = "./target/generator";
    private static final String TEMPLATES_DIR_TEMPLATES = "/simple/templates/";
    private static final String TEMPLATES_DIR_CONTROLLER = "/simple/templates/controller.java";
    private static final String TEMPLATES_DIR_ENTITY = "/simple/templates/entity.java";
    private static final String TEMPLATES_DIR_MAPPER_JAVA = "/simple/templates/mapper.java";
    private static final String TEMPLATES_DIR_MAPPER_XML = "/simple/templates/mapper.xml";
    private static final String TEMPLATES_DIR_SERVICE = "/simple/templates/service.java";
    private static final String TEMPLATES_DIR_SERVICE_IMPL = "/simple/templates/serviceImpl.java";
    private static final String TEMPLATES_DIR_CONFIG = "/simple/templates/config.java.ftl";
    private static final String TEMPLATES_DIR_YML = "/simple/templates/application.yml.ftl";
    private static final String TEMPLATES_DIR_CONFIG_YML = "/simple/templates/configApplication.yml.ftl";
    private static final String TEMPLATES_DIR_POM = "/simple/templates/pom.xml.ftl";
    private static final String TEMPLATES_DIR_APPLICATION = "/simple/templates/application.java.ftl";
    private static final String CUSTOM_FILE_PREFIX = File.separator + ".." + File.separator;

    public static void generate(MybatisGeneratorVo vo) {
        String outputDirPrefixReal = OUTPUT_DIR_PREFIX.replace("/", File.separator);
        StringBuffer outputDirModule = new StringBuffer(outputDirPrefixReal).append(File.separator).append(vo.getPackageName().replace(".", File.separator)).append(File.separator).append(vo.getModuleName()).append(File.separator);
        String outputDirXml = outputDirModule + "mapper" + File.separator + "xml";
        String outputDirController = outputDirModule + "controller";
        String outputDirMapper = outputDirModule + "mapper";
        String outputDirService = outputDirModule + "service";
        String outputDirServiceImpl = outputDirModule + "service" + File.separator + "impl";
        String outputDirEntity = outputDirModule + "entity";
        HashMap<OutputFile, CallSite> pathInfo = new HashMap<OutputFile, CallSite>(16);
        pathInfo.put(OutputFile.xml, (CallSite)((Object)outputDirXml));
        pathInfo.put(OutputFile.controller, (CallSite)((Object)outputDirController));
        pathInfo.put(OutputFile.entity, (CallSite)((Object)outputDirEntity));
        pathInfo.put(OutputFile.mapper, (CallSite)((Object)outputDirMapper));
        pathInfo.put(OutputFile.service, (CallSite)((Object)outputDirService));
        pathInfo.put(OutputFile.serviceImpl, (CallSite)((Object)outputDirServiceImpl));
        StringBuffer customFileConf = new StringBuffer(CUSTOM_FILE_PREFIX).append("config").append(File.separator).append(StringUtils.capitalize((String)vo.getModuleName())).append("AutoConfig.java");
        StringBuffer customFileYml = new StringBuffer(CUSTOM_FILE_PREFIX).append("resources").append(File.separator).append("application.yml");
        StringBuffer customFileConfigYml = new StringBuffer(CUSTOM_FILE_PREFIX).append("resources").append(File.separator).append("config").append(File.separator).append("application.yml");
        StringBuffer customFileApplication = new StringBuffer(CUSTOM_FILE_PREFIX).append(StringUtils.capitalize((String)vo.getModuleName())).append("Application.java");
        StringBuffer customFilePom = new StringBuffer(CUSTOM_FILE_PREFIX).append("pom.xml");
        HashMap<String, String> customFile = new HashMap<String, String>(16);
        customFile.put(customFileConf.toString(), TEMPLATES_DIR_CONFIG);
        customFile.put(customFileYml.toString(), TEMPLATES_DIR_YML);
        customFile.put(customFileConfigYml.toString(), TEMPLATES_DIR_CONFIG_YML);
        customFile.put(customFilePom.toString(), TEMPLATES_DIR_POM);
        customFile.put(customFileApplication.toString(), TEMPLATES_DIR_APPLICATION);
        customFile.put(customFilePom.toString(), TEMPLATES_DIR_POM);
        HashMap<String, CharSequence> customMap = new HashMap<String, CharSequence>(16);
        StringBuffer packageParent = new StringBuffer(vo.getPackageName()).append(".").append(vo.getModuleName());
        customMap.put("packageParent", packageParent.toString());
        packageParent.append(".").append("config");
        customMap.put("packageConfig", packageParent.toString());
        customMap.put("ModuleName", StringUtils.capitalize((String)vo.getModuleName()));
        StringBuffer mapperLocations = new StringBuffer("/").append(vo.getPackageName().replace(".", "/")).append("/").append(vo.getModuleName()).append("/");
        customMap.put("mapperLocations", mapperLocations);
        customMap.put("simpleVersion", SIMPLE_VERSION);
        customMap.put("projectName", vo.getProjectName());
        FastAutoGenerator.create((String)vo.getDataBaseUrl(), (String)vo.getDataBaseUserName(), (String)vo.getDataBasePassword()).globalConfig(builder -> builder.author(vo.getAuthorName()).enableSpringdoc().outputDir(outputDirPrefixReal).disableOpenDir()).packageConfig(builder -> builder.parent(vo.getPackageName()).moduleName(vo.getModuleName()).xml("mapper").pathInfo(pathInfo)).strategyConfig(builder -> {
            builder.addInclude(vo.getTableName());
            if (vo.getTablePrefix() != null) {
                builder.addTablePrefix(vo.getTablePrefix());
            }
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine()).templateConfig(builder -> {
            builder.controller(TEMPLATES_DIR_CONTROLLER);
            builder.mapper(TEMPLATES_DIR_MAPPER_JAVA);
            builder.xml(TEMPLATES_DIR_MAPPER_XML);
            builder.service(TEMPLATES_DIR_SERVICE);
            builder.serviceImpl(TEMPLATES_DIR_SERVICE_IMPL);
            builder.entity(TEMPLATES_DIR_ENTITY);
        }).injectionConfig(builder -> {
            builder.customMap(customMap);
            builder.customFile(customFile);
        }).execute();
    }
}

