/*
 * Decompiled with CFR 0.152.
 */
package cn.iosd.base.generator.database;

import cn.iosd.base.generator.vo.MybatisGeneratorVo;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class MybatisGenerator {
    private static final String SIMPLE_VERSION = "2022.3.5.1";
    private static final String OUTPUT_DIR_PREFIX = "./target/generator";
    private static final String TEMPLATES_DIR_TEMPLATES = "/simple/templates/";
    private static final String TEMPLATES_DIR_CONTROLLER = "/simple/templates/controller.java";
    private static final String TEMPLATES_DIR_ENTITY = "/simple/templates/entity.java";
    private static final String TEMPLATES_DIR_MAPPER_JAVA = "/simple/templates/mapper.java";
    private static final String TEMPLATES_DIR_MAPPER_XML = "/simple/templates/mapper.xml";
    private static final String TEMPLATES_DIR_SERVICE = "/simple/templates/service.java";
    private static final String TEMPLATES_DIR_SERVICE_IMPL = "/simple/templates/serviceImpl.java";
    private static final String TEMPLATES_DIR_CONFIG = "/simple/templates/config.java.ftl";
    private static final String TEMPLATES_DIR_MAPPER_LOCATIONS_PROVIDER = "/simple/templates/mapperLocationsProvider.java.ftl";
    private static final String TEMPLATES_DIR_YML = "/simple/templates/application.yml.ftl";
    private static final String TEMPLATES_DIR_CONFIG_YML = "/simple/templates/configApplication.yml.ftl";
    private static final String TEMPLATES_DIR_POM = "/simple/templates/pom.xml.ftl";
    private static final String TEMPLATES_DIR_APPLICATION = "/simple/templates/application.java.ftl";
    private static final String TEMPLATES_DIR_IMPORTS = "/simple/templates/imports.ftl";
    private static final String TEMPLATES_DIR_EMPTY_FILE = "/simple/templates/emptyFile.ftl";
    private static final String CUSTOM_FILE_PREFIX = "Config" + File.separator;

    public static void generate(MybatisGeneratorVo vo) {
        String outputDirPrefixReal = OUTPUT_DIR_PREFIX.replace("/", File.separator);
        String outputDirModule = String.join((CharSequence)File.separator, outputDirPrefixReal, vo.getPackageName().replace(".", File.separator), vo.getModuleName()) + File.separator;
        String outputDirXml = outputDirModule + "mapper" + File.separator + "xml";
        String outputDirController = outputDirModule + "controller";
        String outputDirMapper = outputDirModule + "mapper";
        String outputDirService = outputDirModule + "service";
        String outputDirServiceImpl = outputDirModule + "service" + File.separator + "impl";
        String outputDirEntity = outputDirModule + "entity";
        HashMap<OutputFile, String> pathInfo = new HashMap<OutputFile, String>(16);
        pathInfo.put(OutputFile.xml, outputDirXml);
        pathInfo.put(OutputFile.controller, outputDirController);
        pathInfo.put(OutputFile.entity, outputDirEntity);
        pathInfo.put(OutputFile.mapper, outputDirMapper);
        pathInfo.put(OutputFile.service, outputDirService);
        pathInfo.put(OutputFile.serviceImpl, outputDirServiceImpl);
        String customFilePrefix = CUSTOM_FILE_PREFIX;
        String moduleName = vo.getModuleName();
        String packageName = vo.getPackageName();
        String capitalizedModuleName = StringUtils.capitalize((String)moduleName);
        String packageParent = packageName + "." + moduleName;
        String configPackage = packageParent + ".config";
        String mapperLocations = "/" + packageName.replace(".", "/") + "/" + moduleName + "/";
        HashMap<String, String> customFile = new HashMap<String, String>();
        customFile.put(customFilePrefix + "config/" + capitalizedModuleName + "AutoConfig.java", TEMPLATES_DIR_CONFIG);
        customFile.put(customFilePrefix + "config/" + capitalizedModuleName + "MapperLocationsProvider.java", TEMPLATES_DIR_MAPPER_LOCATIONS_PROVIDER);
        customFile.put(customFilePrefix + "resources/application.yml", TEMPLATES_DIR_YML);
        customFile.put(customFilePrefix + "resources/config/application.yml", TEMPLATES_DIR_CONFIG_YML);
        customFile.put(customFilePrefix + "resources/META-INF/spring/org.springframework.boot.autoconfigure.AutoConfiguration.imports", TEMPLATES_DIR_IMPORTS);
        customFile.put(customFilePrefix + "resources/db/mysql/" + moduleName + "/V0.1_init_baseline_on_migrate.sql", TEMPLATES_DIR_EMPTY_FILE);
        customFile.put(customFilePrefix + "pom.xml", TEMPLATES_DIR_POM);
        customFile.put(customFilePrefix + capitalizedModuleName + "Application.java", TEMPLATES_DIR_APPLICATION);
        HashMap<String, String> customMap = new HashMap<String, String>(16);
        customMap.put("packageParent", packageParent);
        customMap.put("packageConfig", configPackage);
        customMap.put("ModuleName", capitalizedModuleName);
        customMap.put("mapperLocations", mapperLocations);
        customMap.put("simpleVersion", SIMPLE_VERSION);
        customMap.put("projectName", vo.getProjectName());
        FastAutoGenerator.create((String)vo.getDataBaseUrl(), (String)vo.getDataBaseUserName(), (String)vo.getDataBasePassword()).globalConfig(builder -> builder.author(vo.getAuthorName()).enableSpringdoc().outputDir(outputDirPrefixReal).disableOpenDir()).packageConfig(builder -> builder.parent(packageName).moduleName(moduleName).xml("mapper").pathInfo(pathInfo)).strategyConfig(builder -> {
            builder.addInclude(vo.getTableName());
            if (vo.getTablePrefix() != null) {
                builder.addTablePrefix(vo.getTablePrefix());
            }
        }).templateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine()).templateConfig(builder -> {
            builder.controller(TEMPLATES_DIR_CONTROLLER);
            builder.mapper(TEMPLATES_DIR_MAPPER_JAVA);
            builder.xml(TEMPLATES_DIR_MAPPER_XML);
            builder.service(TEMPLATES_DIR_SERVICE);
            builder.serviceImpl(TEMPLATES_DIR_SERVICE_IMPL);
            builder.entity(TEMPLATES_DIR_ENTITY);
        }).injectionConfig(builder -> {
            builder.customMap(customMap);
            builder.customFile(customFile);
        }).execute();
    }
}

