/*
 * Decompiled with CFR 0.152.
 */
package cn.inusha.hibernate.redisson.spring.boot.starter.processor;

import cn.inusha.hibernate.redisson.spring.boot.starter.factory.SpringJndiRedissonRegionFactory;
import cn.inusha.hibernate.redisson.spring.boot.starter.factory.SpringRedissonRegionFactory;
import cn.inusha.hibernate.redisson.spring.boot.starter.properties.FactoryTypeProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;

public class HibernateRedisCacheBeanPostProcessor
implements BeanPostProcessor {
    private static final String HIBERNATE_SECOND_LEVEL_CACHE_KEY = "hibernate.cache.region.factory_class";
    private final FactoryTypeProperties factoryTypeProperties;

    public HibernateRedisCacheBeanPostProcessor(FactoryTypeProperties factoryTypeProperties) {
        this.factoryTypeProperties = factoryTypeProperties;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        JpaProperties jpaProperties;
        String factoryClass;
        if (bean instanceof JpaProperties && (factoryClass = (String)(jpaProperties = (JpaProperties)bean).getProperties().get(HIBERNATE_SECOND_LEVEL_CACHE_KEY)) == null) {
            jpaProperties.getProperties().put(HIBERNATE_SECOND_LEVEL_CACHE_KEY, this.factoryTypeProperties.getFactoryClass().equals((Object)FactoryTypeProperties.FactoryClass.jndiFactory) ? SpringJndiRedissonRegionFactory.class.getName() : SpringRedissonRegionFactory.class.getName());
        }
        return bean;
    }
}

