package cn.imkarl.sqldsl.sql

import cn.imkarl.sqldsl.column.Column
import cn.imkarl.sqldsl.database.SqlColumnValue

/**
 * SQLWhere
 */
class SQLWhere(
    private val expression: SQLExpression
) : SQLExpression() {

    var offset: Int = 0
    var limit: Int = 0

    val sorts = mutableSetOf<Sort>()

    fun limit(offset: Int, limit: Int): SQLWhere {
        this.offset = offset
        this.limit = limit
        return this
    }

    fun sort(sortField: Column<*>, sortType: SortType): SQLWhere {
        this.sorts.clear()
        this.sorts.add(Sort(sortField, sortType))
        return this
    }

    fun sort(vararg sort: Sort): SQLWhere {
        this.sorts.clear()
        this.sorts.addAll(sort)
        return this
    }

    override fun toSQLBuilder(): String {
        return expression.toSQLBuilder()
    }

    override fun bindArgs(): List<SqlColumnValue<*>> {
        return expression.bindArgs()
    }

}

data class Sort(
    val column: Column<*>,
    val order: SortType
)


/**
 * 排序类型
 */
enum class SortType {
    /** 降序 */
    Desc,
    /** 升序 */
    Asc
}
