package cn.imkarl.sqldsl.sql

import cn.imkarl.sqldsl.column.Column
import cn.imkarl.sqldsl.column.PrimaryKey

/**
 * SQLAlter
 */
abstract class SQLAlterTable {

    abstract fun toSQLBuilder(): String


    companion object {
        fun addColumn(vararg column: Column<*>): SQLAlterTable {
            return AddColumn(column)
        }

        fun dropColumn(vararg column: Column<*>): SQLAlterTable {
            return DropColumn(column.map { it.columnName })
        }
        fun dropColumn(vararg columnName: String): SQLAlterTable {
            return DropColumn(columnName.toList())
        }
    }

}


private class AddColumn(val columns: Array<out Column<*>>) : SQLAlterTable() {

    override fun toSQLBuilder(): String {
        return buildString {
            append("ADD (")
            columns.forEach { column: Column<*> ->
                append(column.columnName)
                append(" ")
                append(column.columnType.sqlType())

                val isPKColumn = column is PrimaryKey
                if (isPKColumn) {
                    append(" PRIMARY KEY")

                    val isAutoIncrement = (column as? PrimaryKey<*>)?.isAutoIncrement ?: false
                    if (isAutoIncrement) {
                        append(" AUTO_INCREMENT")
                    }
                } else {
                    if (column.columnType.nullable) {
                        append(" NULL")
                    } else {
                        append(" NOT NULL")
                    }
                }
            }
            append(")")
        }
    }

}

private class DropColumn(val columns: Collection<String>) : SQLAlterTable() {

    override fun toSQLBuilder(): String {
        return "DROP IF EXISTS ${columns.joinToString(", ")}"
    }

}
