package cn.imkarl.sqldsl.database.h2

import cn.imkarl.sqldsl.database.DatabaseMetaData

/**
 * H2DatabaseMetaData
 */
class H2DatabaseMetaData(val metaData: java.sql.DatabaseMetaData) : DatabaseMetaData() {

    /* Cached values */
    private var _allTableNames: List<String>? = null
    override val tableNames: List<String>
        get() {
            if (_allTableNames != null) {
                return _allTableNames!!
            }

//            "表名：" + rs.getString("TABLE_NAME")
//            "表类型：" + rs.getString("TABLE_TYPE")
//            "表所属数据库：" + rs.getString("TABLE_CAT")
//            "表所属用户名：" + rs.getString("TABLE_SCHEM")
//            "表备注：" + rs.getString("REMARKS")
            return metaData.getTables(null, null, null, arrayOf("TABLE"))
                .toList()
                .map { it["TABLE_NAME"].toString() }
                .also {
                    _allTableNames = it
                }
        }

}