package cn.imkarl.sqldsl.database

import cn.imkarl.sqldsl.sql.SQLExpression
import cn.imkarl.sqldsl.table.Table
import java.sql.SQLException

abstract class Database {

    companion object {
        lateinit var instance: Database
    }


    abstract val metadata: DatabaseMetaData

    abstract fun tableExists(table: Table): Boolean

    @Throws(SQLException::class)
    fun executeUpdate(sql: String): Int {
        return executeUpdate(sql, null as Array<SqlColumnValue<*>>?)
    }
    @Throws(SQLException::class)
    fun executeUpdate(sql: String, bindArgs: Collection<SqlColumnValue<*>>?): Int {
        return executeUpdate(sql, bindArgs?.toTypedArray())
    }
    @Throws(SQLException::class)
    abstract fun executeUpdate(sql: String, bindArgs: Array<SqlColumnValue<*>>?): Int



    @Throws(SQLException::class)
    fun executeQuery(sql: String): List<Map<String, Any?>> {
        return executeQuery(sql, null as Array<SqlColumnValue<*>>?)
    }
    @Throws(SQLException::class)
    fun executeQuery(sql: String, selectionArgs: Collection<SqlColumnValue<*>>?): List<Map<String, Any?>> {
        return executeQuery(sql, selectionArgs?.toTypedArray())
    }
    @Throws(SQLException::class)
    abstract fun executeQuery(sql: String, selectionArgs: Array<SqlColumnValue<*>>? = null): List<Map<String, Any?>>




    @Throws(SQLException::class)
    abstract fun count(table: Table, where: SQLExpression? = null): Long



    @Throws(SQLException::class)
    abstract fun createTable(vararg tables: Table)

    @Throws(SQLException::class)
    abstract fun dropTable(vararg tables: Table)

    @Throws(SQLException::class)
    abstract fun insert(row: Table.Row): Int

    @Throws(SQLException::class)
    abstract fun <T: Any> insertAndGetId(row: Table.Row): T

    @Throws(SQLException::class)
    abstract fun update(row: Table.Row, where: SQLExpression? = null): Int

    @Throws(SQLException::class)
    abstract fun deleteAll(table: Table): Int
    @Throws(SQLException::class)
    abstract fun deleteById(row: Table.Row): Int
    @Throws(SQLException::class)
    abstract fun deleteWhere(table: Table, where: SQLExpression? = null): Int

    @Throws(SQLException::class)
    abstract fun selectAll(table: Table): List<Table.Row>
    @Throws(SQLException::class)
    abstract fun select(table: Table, where: SQLExpression? = null): List<Table.Row>

}
