package cn.imkarl.sqldsl.column

/**
 * 主键
 */
class PrimaryKey<T: Any>(
    column: Column<T>,
    /** 是否自增 */
    val pkName: String,
    /** 是否自增 */
    var isAutoIncrement: Boolean
): Column<T>(column.table, column.columnName, column.columnType) {


    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false
        if (!super.equals(other)) return false

        other as PrimaryKey<*>

        if (pkName != other.pkName) return false
        if (isAutoIncrement != other.isAutoIncrement) return false

        return true
    }

    override fun hashCode(): Int {
        var result = super.hashCode()
        result = 31 * result + pkName.hashCode()
        result = 31 * result + isAutoIncrement.hashCode()
        return result
    }

}
