package cn.imkarl.sqldsl.column

import cn.imkarl.sqldsl.table.Table
import java.util.*

private val comparator: Comparator<Column<*>> = compareBy({ it.table.tableName }, { it.columnName })

/**
 * Represents a column.
 */
open class Column<T: Any?>(
    /** Table where the columns is declared. */
    val table: Table,
    /** Name of the column. */
    val columnName: String,
    /** Data type of the column. */
    val columnType: ColumnType<*>
) : Comparable<Column<*>> {

    /** 获取该列默认值的函数 */
    var defaultValueFun: (() -> T) = { columnType.defaultValue as T }


    /** Sets the default value for this column in the database side. */
    fun default(defaultValue: T): Column<T> = apply {
        this.defaultValueFun = { defaultValue }
    }

    /** Sets the default value for this column in the database side. */
    fun default(defaultValue: () -> T): Column<T> = apply {
        this.defaultValueFun = defaultValue
    }




    override fun compareTo(other: Column<*>): Int = comparator.compare(this, other)

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is Column<*>) return false
        if (!super.equals(other)) return false

        if (table != other.table) return false
        if (columnName != other.columnName) return false
        if (columnType != other.columnType) return false

        return true
    }

    override fun hashCode(): Int {
        var result = table.hashCode()
        result = 31 * result + columnName.hashCode()
        result = 31 * result + columnType.hashCode()
        return result
    }

    override fun toString(): String = "${table.javaClass.name}.$columnName"

}
