package cn.imkarl.core.common.collections

import cn.imkarl.core.common.lang.cast
import cn.imkarl.core.common.lang.isSubclass
import org.bson.Document


inline fun <reified T> Document.getValue(key: String): T {
    if (T::class.isSubclass(List::class)) {
        return this.getList(key, Any::class.java).toList() as T
    }
    if (T::class.isSubclass(Set::class)) {
        return this.getList(key, Any::class.java).toSet() as T
    }
    if (T::class.isSubclass(Collection::class)) {
        return this.getList(key, Any::class.java) as T
    }
    if (T::class.isSubclass(Array::class)) {
        return this.getList(key, Any::class.java).toTypedArray() as T
    }
    return this[key]?.toString().cast<T>()
}
