/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.time;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\r\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcn/imkarl/core/common/time/Dates;", "", "milliseconds", "", "<init>", "(J)V", "getMilliseconds", "()J", "format", "", "pattern", "toCalendar", "Ljava/util/Calendar;", "zone", "Ljava/util/TimeZone;", "toDate", "Ljava/util/Date;", "toDateTime", "Ljava/time/LocalDateTime;", "Ljava/time/ZoneId;", "Companion", "Common"})
public final class Dates {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long milliseconds;

    private Dates(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public final long getMilliseconds() {
        return this.milliseconds;
    }

    @NotNull
    public final String format(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = new SimpleDateFormat(pattern).format(this.milliseconds);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static /* synthetic */ String format$default(Dates dates, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        return dates.format(string);
    }

    @NotNull
    public final Calendar toCalendar(@NotNull TimeZone zone) {
        Calendar calendar;
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        Calendar $this$toCalendar_u24lambda_u240 = calendar = Calendar.getInstance();
        boolean bl = false;
        $this$toCalendar_u24lambda_u240.setTimeInMillis(this.milliseconds);
        $this$toCalendar_u24lambda_u240.setTimeZone(zone);
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"apply(...)");
        return calendar2;
    }

    public static /* synthetic */ Calendar toCalendar$default(Dates dates, TimeZone timeZone, int n, Object object) {
        if ((n & 1) != 0) {
            timeZone = TimeZone.getDefault();
        }
        return dates.toCalendar(timeZone);
    }

    @NotNull
    public final Date toDate() {
        return new Date(this.milliseconds);
    }

    @NotNull
    public final LocalDateTime toDateTime(@NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.milliseconds), zone);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(...)");
        return localDateTime;
    }

    public static /* synthetic */ LocalDateTime toDateTime$default(Dates dates, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            zoneId = ZoneId.systemDefault();
        }
        return dates.toDateTime(zoneId);
    }

    public /* synthetic */ Dates(long milliseconds, DefaultConstructorMarker $constructor_marker) {
        this(milliseconds);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000fJ\u0017\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0011J\u0006\u0010\u0012\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"Lcn/imkarl/core/common/time/Dates$Companion;", "", "<init>", "()V", "of", "Lcn/imkarl/core/common/time/Dates;", "milliseconds", "", "parse", "dateTime", "Ljava/time/LocalDateTime;", "zone", "Ljava/time/ZoneId;", "date", "Ljava/sql/Date;", "Ljava/util/Date;", "(Ljava/lang/Long;)Lcn/imkarl/core/common/time/Dates;", "", "today", "Common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Dates of(long milliseconds) {
            return new Dates(milliseconds > 1000000000000L ? milliseconds : milliseconds * (long)1000, null);
        }

        @Nullable
        public final Dates parse(@Nullable LocalDateTime dateTime, @NotNull ZoneId zone) {
            Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
            if (dateTime == null) {
                return null;
            }
            return this.of(dateTime.atZone(zone).toInstant().toEpochMilli());
        }

        public static /* synthetic */ Dates parse$default(Companion companion, LocalDateTime localDateTime, ZoneId zoneId, int n, Object object) {
            if ((n & 2) != 0) {
                zoneId = ZoneId.systemDefault();
            }
            return companion.parse(localDateTime, zoneId);
        }

        @Nullable
        public final Dates parse(@Nullable java.sql.Date date) {
            if (date == null) {
                return null;
            }
            return this.of(date.getTime());
        }

        @Nullable
        public final Dates parse(@Nullable Date date) {
            if (date == null) {
                return null;
            }
            return this.of(date.getTime());
        }

        @Nullable
        public final Dates parse(@Nullable Long milliseconds) {
            if (milliseconds == null || milliseconds < 0L) {
                return null;
            }
            return this.of(milliseconds);
        }

        @Nullable
        public final Dates parse(@Nullable String dateTime) {
            long l;
            CharSequence charSequence = dateTime;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            try {
                long l2;
                CharSequence charSequence2 = dateTime;
                if (new Regex("^[0-9]{10}$|^[0-9]{13}$").matches(charSequence2)) {
                    Long l3 = StringsKt.toLongOrNull((String)dateTime);
                    l2 = l3 != null ? l3 : -1L;
                } else {
                    charSequence2 = dateTime;
                    l2 = new Regex("[0-9]T[0-9]").containsMatchIn(charSequence2) ? (!StringsKt.isBlank((CharSequence)dateTime) ? OffsetDateTime.parse(dateTime).toInstant().toEpochMilli() : -1L) : (StringsKt.contains$default((CharSequence)dateTime, (CharSequence)",", (boolean)false, (int)2, null) ? new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").parse(dateTime).getTime() : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateTime).getTime());
                }
                l = l2;
            }
            catch (Throwable throwable) {
                l = -1L;
            }
            long milliseconds = l;
            if (milliseconds < 0L) {
                return null;
            }
            return new Dates(milliseconds, null);
        }

        @NotNull
        public final Dates today() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return this.of(calendar.getTimeInMillis());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

