/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.security;

import cn.imkarl.core.common.encode.EncodeExtensionsKt;
import cn.imkarl.core.common.encode.EncodeUtils;
import cn.imkarl.core.common.io.StreamsExtensionsKt;
import cn.imkarl.core.common.log.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J$\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0016\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0018J\u0016\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0005\u00a8\u0006\u001d"}, d2={"Lcn/imkarl/core/common/security/EncryptUtils;", "", "<init>", "()V", "md5", "", "data", "", "file", "Ljava/io/File;", "sha1", "hmacMD5ToString", "key", "hmacMD5", "hmacSHA1ToString", "hmacSHA1", "hashTemplate", "algorithm", "hmacTemplate", "encryptDES", "decryptDES", "encryptAES", "decryptAES", "generatorRSAKey", "Lkotlin/Pair;", "encryptRSA", "publicKey", "decryptRSA", "privateKey", "Common"})
public final class EncryptUtils {
    @NotNull
    public static final EncryptUtils INSTANCE = new EncryptUtils();

    private EncryptUtils() {
    }

    @Nullable
    public final String md5(@Nullable String data) {
        if (data == null) {
            return null;
        }
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.md5(byArray);
    }

    @Nullable
    public final String md5(@Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hashTemplate("MD5", data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String md5(@Nullable File file) {
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        DigestInputStream digestInputStream = null;
        try {
            fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            digestInputStream = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (digestInputStream.read(buffer) > 0) {
            }
            md = digestInputStream.getMessageDigest();
            String string = EncodeUtils.bytesToHexString(md.digest());
            return string;
        }
        catch (Exception e) {
            LogUtils.e(e);
            String string = null;
            return string;
        }
        finally {
            StreamsExtensionsKt.closeQuietly(fis);
        }
    }

    @Nullable
    public final String sha1(@Nullable String data) {
        if (data == null) {
            return null;
        }
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.sha1(byArray);
    }

    @Nullable
    public final String sha1(@Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hashTemplate("SHA1", data));
    }

    @Nullable
    public final String hmacMD5ToString(@NotNull String key, @Nullable String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        string = data;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        return this.hmacMD5ToString(byArray, byArray2);
    }

    @Nullable
    public final String hmacMD5ToString(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hmacMD5(key, data));
    }

    @Nullable
    public final byte[] hmacMD5(@NotNull String key, @Nullable String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        string = data;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        return this.hmacMD5(byArray, byArray2);
    }

    @Nullable
    public final byte[] hmacMD5(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return this.hmacTemplate("HmacMD5", key, data);
    }

    @Nullable
    public final String hmacSHA1ToString(@NotNull String key, @Nullable String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        string = data;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        return this.hmacSHA1ToString(byArray, byArray2);
    }

    @Nullable
    public final String hmacSHA1ToString(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hmacSHA1(key, data));
    }

    @Nullable
    public final byte[] hmacSHA1(@NotNull String key, @Nullable String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        string = data;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        return this.hmacSHA1(byArray, byArray2);
    }

    @Nullable
    public final byte[] hmacSHA1(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return this.hmacTemplate("HmacSHA1", key, data);
    }

    private final byte[] hashTemplate(String algorithm, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            if (!(data.length == 0)) {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                md.update(data);
                return md.digest();
            }
        }
        catch (NoSuchAlgorithmException e) {
            LogUtils.e(e);
        }
        return null;
    }

    private final byte[] hmacTemplate(String algorithm, byte[] key, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            if (!(key.length == 0) && !(data.length == 0)) {
                Mac mac = Mac.getInstance(algorithm);
                SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
                mac.init(secretKey);
                return mac.doFinal(data);
            }
        }
        catch (InvalidKeyException e) {
            LogUtils.e(e);
        }
        catch (NoSuchAlgorithmException e) {
            LogUtils.e(e);
        }
        return null;
    }

    @NotNull
    public final byte[] encryptDES(@NotNull String data, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Cipher cipher = Cipher.getInstance("DES");
        SecretKeyFactory kf = SecretKeyFactory.getInstance("DES");
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        DESKeySpec keySpec = new DESKeySpec(byArray);
        SecretKey secretKey = kf.generateSecret(keySpec);
        cipher.init(1, secretKey);
        String string2 = data;
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] byArray3 = cipher.doFinal(byArray2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"doFinal(...)");
        return byArray3;
    }

    @NotNull
    public final String decryptDES(@NotNull byte[] data, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Cipher cipher = Cipher.getInstance("DES");
        SecretKeyFactory kf = SecretKeyFactory.getInstance("DES");
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        DESKeySpec keySpec = new DESKeySpec(byArray);
        SecretKey secretKey = kf.generateSecret(keySpec);
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateSecret(...)");
        Key secretKey2 = secretKey;
        cipher.init(2, secretKey2);
        byte[] decrypt = cipher.doFinal(data);
        Intrinsics.checkNotNull((Object)decrypt);
        return new String(decrypt, Charsets.UTF_8);
    }

    @NotNull
    public final byte[] encryptAES(@NotNull String data, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Cipher cipher = Cipher.getInstance("AES");
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        SecretKeySpec keySpec = new SecretKeySpec(byArray, "AES");
        cipher.init(1, keySpec);
        String string2 = data;
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] byArray3 = cipher.doFinal(byArray2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"doFinal(...)");
        return byArray3;
    }

    @NotNull
    public final String decryptAES(@NotNull byte[] data, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Cipher cipher = Cipher.getInstance("AES");
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        SecretKeySpec keySpec = new SecretKeySpec(byArray, "AES");
        cipher.init(2, keySpec);
        byte[] decrypt = cipher.doFinal(data);
        Intrinsics.checkNotNull((Object)decrypt);
        return new String(decrypt, Charsets.UTF_8);
    }

    @NotNull
    public final Pair<String, String> generatorRSAKey() {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        KeyPair keyPair = generator.genKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        byte[] byArray = publicKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        String string = EncodeExtensionsKt.encodeBase64(byArray);
        Intrinsics.checkNotNull((Object)string);
        byte[] byArray2 = privateKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
        String string2 = EncodeExtensionsKt.encodeBase64(byArray2);
        Intrinsics.checkNotNull((Object)string2);
        return TuplesKt.to((Object)string, (Object)string2);
    }

    @NotNull
    public final byte[] encryptRSA(@NotNull String data, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey rsaPublicKey = keyFactory.generatePublic(new X509EncodedKeySpec(EncodeExtensionsKt.decodeBase64(publicKey)));
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, rsaPublicKey);
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = cipher.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"doFinal(...)");
        return byArray2;
    }

    @NotNull
    public final String decryptRSA(@NotNull byte[] data, @NotNull String privateKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey rsaPrivateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(EncodeExtensionsKt.decodeBase64(privateKey)));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, rsaPrivateKey);
        byte[] decrypt = cipher.doFinal(data);
        Intrinsics.checkNotNull((Object)decrypt);
        return new String(decrypt, Charsets.UTF_8);
    }
}

