/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.random;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcn/imkarl/core/common/random/Snowflake;", "", "workerId", "", "dataCenterId", "randomSequenceLimit", "timeOffset", "twepoch", "<init>", "(JJJJJ)V", "sequence", "lastTimestamp", "getWorkerId", "id", "getDataCenterId", "getGenerateDateTime", "nextId", "tilNextMillis", "genTime", "checkBetween", "", "value", "min", "max", "Companion", "Common"})
public final class Snowflake {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long workerId;
    private final long dataCenterId;
    private final long randomSequenceLimit;
    private final long timeOffset;
    private final long twepoch;
    private long sequence;
    private long lastTimestamp;
    @NotNull
    private static final ConcurrentHashMap<String, Snowflake> POOL = new ConcurrentHashMap();
    private static long DEFAULT_TWEPOCH = 1288834974657L;
    private static long DEFAULT_TIME_OFFSET = 2000L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;

    public Snowflake(long workerId, long dataCenterId, long randomSequenceLimit, long timeOffset, long twepoch) {
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.randomSequenceLimit = randomSequenceLimit;
        this.timeOffset = timeOffset;
        this.twepoch = twepoch;
        this.checkBetween(this.workerId, 0L, 31L);
        this.checkBetween(this.dataCenterId, 0L, 31L);
        this.checkBetween(this.randomSequenceLimit, 0L, 4095L);
        this.lastTimestamp = -1L;
    }

    public /* synthetic */ Snowflake(long l, long l2, long l3, long l4, long l5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            l2 = 0L;
        }
        if ((n & 4) != 0) {
            l3 = 0L;
        }
        if ((n & 8) != 0) {
            l4 = DEFAULT_TIME_OFFSET;
        }
        if ((n & 0x10) != 0) {
            l5 = DEFAULT_TWEPOCH;
        }
        this(l, l2, l3, l4, l5);
    }

    public final long getWorkerId(long id) {
        return id >> 12 & 0x1FL;
    }

    public final long getDataCenterId(long id) {
        return id >> 17 & 0x1FL;
    }

    public final long getGenerateDateTime(long id) {
        return (id >> 22 & 0x1FFFFFFFFFFL) + this.twepoch;
    }

    public final synchronized long nextId() {
        long timestamp = this.genTime();
        if (timestamp < this.lastTimestamp) {
            if (this.lastTimestamp - timestamp < this.timeOffset) {
                timestamp = this.lastTimestamp;
            } else {
                throw new IllegalStateException("Clock moved backwards. Refusing to generate id for " + (this.lastTimestamp - timestamp) + "ms");
            }
        }
        if (timestamp == this.lastTimestamp) {
            long sequence = this.sequence + 1L & 0xFFFL;
            if (sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
            this.sequence = sequence;
        } else {
            this.sequence = this.randomSequenceLimit > 1L ? ThreadLocalRandom.current().nextLong(this.randomSequenceLimit) : 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private final long tilNextMillis(long lastTimestamp) {
        long timestamp = this.genTime();
        while (timestamp == lastTimestamp) {
            timestamp = this.genTime();
        }
        if (timestamp < lastTimestamp) {
            throw new IllegalStateException("Clock moved backwards. Refusing to generate id for " + (lastTimestamp - timestamp) + "ms");
        }
        return timestamp;
    }

    private final long genTime() {
        return System.currentTimeMillis();
    }

    private final void checkBetween(long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("The value must be between " + min + " and " + max + '.');
        }
    }

    public Snowflake() {
        this(0L, 0L, 0L, 0L, 0L, 31, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0016\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\t2\b\b\u0002\u0010\u001c\u001a\u00020\tJ)\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010 \"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010!R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcn/imkarl/core/common/random/Snowflake$Companion;", "", "<init>", "()V", "POOL", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcn/imkarl/core/common/random/Snowflake;", "DEFAULT_TWEPOCH", "", "getDEFAULT_TWEPOCH$Common", "()J", "setDEFAULT_TWEPOCH$Common", "(J)V", "DEFAULT_TIME_OFFSET", "getDEFAULT_TIME_OFFSET$Common", "setDEFAULT_TIME_OFFSET$Common", "WORKER_ID_BITS", "MAX_WORKER_ID", "DATA_CENTER_ID_BITS", "MAX_DATA_CENTER_ID", "SEQUENCE_BITS", "WORKER_ID_SHIFT", "DATA_CENTER_ID_SHIFT", "TIMESTAMP_LEFT_SHIFT", "SEQUENCE_MASK", "getSnowflake", "workerId", "datacenterId", "buildKey", "className", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "Common"})
    @SourceDebugExtension(value={"SMAP\nSnowflake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Snowflake.kt\ncn/imkarl/core/common/random/Snowflake$Companion\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n72#2,2:248\n1#3:250\n*S KotlinDebug\n*F\n+ 1 Snowflake.kt\ncn/imkarl/core/common/random/Snowflake$Companion\n*L\n99#1:248,2\n99#1:250\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEFAULT_TWEPOCH$Common() {
            return DEFAULT_TWEPOCH;
        }

        public final void setDEFAULT_TWEPOCH$Common(long l) {
            DEFAULT_TWEPOCH = l;
        }

        public final long getDEFAULT_TIME_OFFSET$Common() {
            return DEFAULT_TIME_OFFSET;
        }

        public final void setDEFAULT_TIME_OFFSET$Common(long l) {
            DEFAULT_TIME_OFFSET = l;
        }

        @NotNull
        public final Snowflake getSnowflake(long workerId, long datacenterId) {
            String string = this.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Object[] objectArray = new Object[]{workerId, datacenterId};
            String key = this.buildKey(string, objectArray);
            ConcurrentMap $this$getOrPut$iv = POOL;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key);
            if (object == null) {
                boolean bl = false;
                Snowflake default$iv = new Snowflake(workerId, datacenterId, 0L, 0L, 0L, 28, null);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
            return (Snowflake)object;
        }

        public static /* synthetic */ Snowflake getSnowflake$default(Companion companion, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            return companion.getSnowflake(l, l2);
        }

        private final String buildKey(String className, Object ... params) {
            return params.length == 0 ? className : className + '#' + ArraysKt.joinToString$default((Object[])params, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

