/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.random;

import java.security.SecureRandom;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"DEFAULT_NUMBER_GENERATOR", "Ljava/security/SecureRandom;", "DEFAULT_ALPHABET", "", "DEFAULT_SIZE", "", "randomNanoId", "", "random", "Ljava/util/Random;", "alphabet", "size", "Common"})
@SourceDebugExtension(value={"SMAP\nNanoId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NanoId.kt\ncn/imkarl/core/common/random/NanoIdKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class NanoIdKt {
    @NotNull
    private static final SecureRandom DEFAULT_NUMBER_GENERATOR = new SecureRandom();
    @NotNull
    private static final char[] DEFAULT_ALPHABET;
    private static final int DEFAULT_SIZE = 21;

    @NotNull
    public static final String randomNanoId() {
        return NanoIdKt.randomNanoId(DEFAULT_NUMBER_GENERATOR, DEFAULT_ALPHABET, 21);
    }

    @NotNull
    public static final String randomNanoId(@NotNull Random random, @NotNull char[] alphabet, int size) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)alphabet, (String)"alphabet");
        if (!(!(alphabet.length == 0) && alphabet.length < 256)) {
            boolean $i$a$-require-NanoIdKt$randomNanoId$32 = false;
            String $i$a$-require-NanoIdKt$randomNanoId$32 = "alphabet must contain between 1 and 255 symbols.";
            throw new IllegalArgumentException($i$a$-require-NanoIdKt$randomNanoId$32.toString());
        }
        if (!(size > 0)) {
            boolean $i$a$-require-NanoIdKt$randomNanoId$42 = false;
            String $i$a$-require-NanoIdKt$randomNanoId$42 = "size must be greater than zero.";
            throw new IllegalArgumentException($i$a$-require-NanoIdKt$randomNanoId$42.toString());
        }
        int mask = (2 << (int)Math.floor(Math.log(alphabet.length - 1) / Math.log(2.0))) - 1;
        int step = (int)Math.ceil(1.6 * (double)mask * (double)size / (double)alphabet.length);
        StringBuilder idBuilder = new StringBuilder();
        block0: while (true) {
            byte[] bytes2 = new byte[step];
            random.nextBytes(bytes2);
            int i = 0;
            while (true) {
                if (i >= step) continue block0;
                int alphabetIndex = bytes2[i] & mask;
                if (alphabetIndex < alphabet.length) {
                    idBuilder.append(alphabet[alphabetIndex]);
                    if (idBuilder.length() == size) {
                        String string = idBuilder.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        return string;
                    }
                }
                ++i;
            }
            break;
        }
    }

    static {
        char[] cArray = "_-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        DEFAULT_ALPHABET = cArray;
    }
}

